/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectBootstrapper;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.bootstrap.BootstrapSettings;

class DefaultProjectBootstrapper
implements ProjectBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProjectBootstrapper.class);
    private static final String PROPERTY_PROJECT_BASEDIR = "sonar.projectBaseDir";
    private static final String PROPERTY_PROJECT_CONFIG_FILE = "sonar.projectConfigFile";
    private static final String PROPERTY_MODULES = "sonar.modules";
    private static final String PROPERTY_SOURCES = "sonar.sources";
    private static final String PROPERTY_TESTS = "sonar.tests";
    private static final String PROPERTY_BINARIES = "sonar.binaries";
    private static final String PROPERTY_LIBRARIES = "sonar.libraries";
    private static final String PROPERTY_OLD_SOURCES = "sources";
    private static final String PROPERTY_OLD_TESTS = "tests";
    private static final String PROPERTY_OLD_BINARIES = "binaries";
    private static final String PROPERTY_OLD_LIBRARIES = "libraries";
    private static final Map<String, String> DEPRECATED_PROPS_TO_NEW_PROPS = ImmutableMap.of((Object)"sources", (Object)"sonar.sources", (Object)"tests", (Object)"sonar.tests", (Object)"binaries", (Object)"sonar.binaries", (Object)"libraries", (Object)"sonar.libraries");
    private static final String[] MANDATORY_PROPERTIES_FOR_SIMPLE_PROJECT = new String[]{"sonar.projectBaseDir", "sonar.projectKey", "sonar.projectName", "sonar.projectVersion", "sonar.sources"};
    private static final String[] MANDATORY_PROPERTIES_FOR_MULTIMODULE_PROJECT = new String[]{"sonar.projectBaseDir", "sonar.projectKey", "sonar.projectName", "sonar.projectVersion"};
    private static final String[] MANDATORY_PROPERTIES_FOR_CHILD = new String[]{"sonar.projectKey", "sonar.projectName"};
    private static final List<String> NON_HERITED_PROPERTIES_FOR_CHILD = Lists.newArrayList((Object[])new String[]{"sonar.projectBaseDir", "sonar.modules", "sonar.projectDescription"});
    private BootstrapSettings settings;
    private File rootProjectWorkDir;

    DefaultProjectBootstrapper(BootstrapSettings settings) {
        this.settings = settings;
    }

    public ProjectReactor bootstrap() {
        Properties bootstrapProperties = new Properties();
        bootstrapProperties.putAll(this.settings.properties());
        ProjectDefinition rootProject = this.defineProject(bootstrapProperties, null);
        this.rootProjectWorkDir = rootProject.getWorkDir();
        this.defineChildren(rootProject);
        DefaultProjectBootstrapper.cleanAndCheckProjectDefinitions(rootProject);
        return new ProjectReactor(rootProject);
    }

    private ProjectDefinition defineProject(Properties properties, ProjectDefinition parent) {
        File workDir;
        File baseDir = new File(properties.getProperty(PROPERTY_PROJECT_BASEDIR));
        if (properties.containsKey(PROPERTY_MODULES)) {
            DefaultProjectBootstrapper.checkMandatoryProperties(properties, MANDATORY_PROPERTIES_FOR_MULTIMODULE_PROJECT);
        } else {
            DefaultProjectBootstrapper.checkMandatoryProperties(properties, MANDATORY_PROPERTIES_FOR_SIMPLE_PROJECT);
        }
        if (parent == null) {
            DefaultProjectBootstrapper.validateDirectories(properties, baseDir, properties.getProperty("sonar.projectKey"));
            workDir = this.initRootProjectWorkDir(baseDir);
        } else {
            workDir = this.initModuleWorkDir(properties);
        }
        ProjectDefinition definition = ProjectDefinition.create().setProperties(properties).setBaseDir(baseDir).setWorkDir(workDir);
        return definition;
    }

    @VisibleForTesting
    protected File initRootProjectWorkDir(File baseDir) {
        String workDir = this.settings.property("sonar.working.directory");
        if (StringUtils.isBlank((String)workDir)) {
            return new File(baseDir, ".sonar");
        }
        File customWorkDir = new File(workDir);
        if (customWorkDir.isAbsolute()) {
            return customWorkDir;
        }
        return new File(baseDir, customWorkDir.getPath());
    }

    @VisibleForTesting
    protected File initModuleWorkDir(Properties properties) {
        String cleanKey = StringUtils.deleteWhitespace((String)properties.getProperty("sonar.projectKey"));
        cleanKey = StringUtils.replace((String)cleanKey, (String)":", (String)"_");
        return new File(this.rootProjectWorkDir, cleanKey);
    }

    private void defineChildren(ProjectDefinition parentProject) {
        Properties parentProps = parentProject.getProperties();
        if (parentProps.containsKey(PROPERTY_MODULES)) {
            for (String module : DefaultProjectBootstrapper.getListFromProperty(parentProps, PROPERTY_MODULES)) {
                Properties moduleProps = DefaultProjectBootstrapper.extractModuleProperties(module, parentProps);
                ProjectDefinition childProject = this.loadChildProject(parentProject, moduleProps, module);
                DefaultProjectBootstrapper.checkUniquenessOfChildKey(childProject, parentProject);
                this.defineChildren(childProject);
                parentProject.addSubProject(childProject);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private ProjectDefinition loadChildProject(ProjectDefinition parentProject, Properties moduleProps, String moduleId) {
        DefaultProjectBootstrapper.setProjectKeyAndNameIfNotDefined(moduleProps, moduleId);
        if (moduleProps.containsKey("sonar.projectBaseDir")) {
            baseDir = DefaultProjectBootstrapper.getFileFromPath(moduleProps.getProperty("sonar.projectBaseDir"), parentProject.getBaseDir());
            DefaultProjectBootstrapper.setProjectBaseDir(baseDir, moduleProps, moduleId);
            try {
                if (parentProject.getBaseDir().getCanonicalFile().equals(baseDir.getCanonicalFile())) ** GOTO lbl17
                this.tryToFindAndLoadPropsFile(baseDir, moduleProps, moduleId);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error when resolving baseDir", e);
            }
        } else if (moduleProps.containsKey("sonar.projectConfigFile")) {
            baseDir = this.loadPropsFile(parentProject, moduleProps, moduleId);
        } else {
            baseDir = new File(parentProject.getBaseDir(), moduleId);
            DefaultProjectBootstrapper.setProjectBaseDir(baseDir, moduleProps, moduleId);
            this.tryToFindAndLoadPropsFile(baseDir, moduleProps, moduleId);
        }
lbl17:
        // 4 sources

        DefaultProjectBootstrapper.checkMandatoryProperties(moduleProps, DefaultProjectBootstrapper.MANDATORY_PROPERTIES_FOR_CHILD);
        DefaultProjectBootstrapper.validateDirectories(moduleProps, baseDir, moduleId);
        DefaultProjectBootstrapper.mergeParentProperties(moduleProps, parentProject.getProperties());
        DefaultProjectBootstrapper.prefixProjectKeyWithParentKey(moduleProps, parentProject.getKey());
        return this.defineProject(moduleProps, parentProject);
    }

    protected File loadPropsFile(ProjectDefinition parentProject, Properties moduleProps, String moduleId) {
        File propertyFile = DefaultProjectBootstrapper.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_CONFIG_FILE), parentProject.getBaseDir());
        if (propertyFile.isFile()) {
            Properties propsFromFile = DefaultProjectBootstrapper.toProperties(propertyFile);
            for (Map.Entry<Object, Object> entry : propsFromFile.entrySet()) {
                moduleProps.put(entry.getKey(), entry.getValue());
            }
            File baseDir = null;
            baseDir = moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR) ? DefaultProjectBootstrapper.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), propertyFile.getParentFile()) : propertyFile.getParentFile();
            DefaultProjectBootstrapper.setProjectBaseDir(baseDir, moduleProps, moduleId);
            return baseDir;
        }
        throw new IllegalStateException("The properties file of the module '" + moduleId + "' does not exist: " + propertyFile.getAbsolutePath());
    }

    private void tryToFindAndLoadPropsFile(File baseDir, Properties moduleProps, String moduleId) {
        File propertyFile = new File(baseDir, "sonar-project.properties");
        if (propertyFile.isFile()) {
            Properties propsFromFile = DefaultProjectBootstrapper.toProperties(propertyFile);
            for (Map.Entry<Object, Object> entry : propsFromFile.entrySet()) {
                moduleProps.put(entry.getKey(), entry.getValue());
            }
            if (moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
                File overwrittenBaseDir = DefaultProjectBootstrapper.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), propertyFile.getParentFile());
                DefaultProjectBootstrapper.setProjectBaseDir(overwrittenBaseDir, moduleProps, moduleId);
            }
        }
    }

    @VisibleForTesting
    protected static Properties toProperties(File propertyFile) {
        Properties propsFromFile = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(propertyFile);
            propsFromFile.load(fileInputStream);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Impossible to read the property file: " + propertyFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return propsFromFile;
    }

    @VisibleForTesting
    protected static void setProjectKeyAndNameIfNotDefined(Properties childProps, String moduleId) {
        if (!childProps.containsKey("sonar.projectKey")) {
            childProps.put("sonar.projectKey", moduleId);
        }
        if (!childProps.containsKey("sonar.projectName")) {
            childProps.put("sonar.projectName", moduleId);
        }
    }

    @VisibleForTesting
    protected static void checkUniquenessOfChildKey(ProjectDefinition childProject, ProjectDefinition parentProject) {
        for (ProjectDefinition definition : parentProject.getSubProjects()) {
            if (!definition.getKey().equals(childProject.getKey())) continue;
            throw new IllegalStateException("Project '" + parentProject.getKey() + "' can't have 2 modules with the following key: " + childProject.getKey());
        }
    }

    @VisibleForTesting
    protected static void prefixProjectKeyWithParentKey(Properties childProps, String parentKey) {
        String childKey = childProps.getProperty("sonar.projectKey");
        childProps.put("sonar.projectKey", parentKey + ":" + childKey);
    }

    private static void setProjectBaseDir(File baseDir, Properties childProps, String moduleId) {
        if (!baseDir.isDirectory()) {
            throw new IllegalStateException("The base directory of the module '" + moduleId + "' does not exist: " + baseDir.getAbsolutePath());
        }
        childProps.put(PROPERTY_PROJECT_BASEDIR, baseDir.getAbsolutePath());
    }

    @VisibleForTesting
    protected static void checkMandatoryProperties(Properties props, String[] mandatoryProps) {
        DefaultProjectBootstrapper.replaceDeprecatedProperties(props);
        StringBuilder missing = new StringBuilder();
        for (String mandatoryProperty : mandatoryProps) {
            if (props.containsKey(mandatoryProperty)) continue;
            if (missing.length() > 0) {
                missing.append(", ");
            }
            missing.append(mandatoryProperty);
        }
        String projectKey = props.getProperty("sonar.projectKey");
        if (missing.length() != 0) {
            throw new IllegalStateException("You must define the following mandatory properties for '" + (projectKey == null ? "Unknown" : projectKey) + "': " + missing);
        }
    }

    private static void validateDirectories(Properties props, File baseDir, String projectId) {
        if (!props.containsKey(PROPERTY_MODULES)) {
            for (String pattern : DefaultProjectBootstrapper.getListFromProperty(props, PROPERTY_LIBRARIES)) {
                File[] files = DefaultProjectBootstrapper.getLibraries(baseDir, pattern);
                if (files != null && files.length != 0) continue;
                LOG.error("Invalid value of sonar.libraries for " + projectId);
                throw new IllegalStateException("No files nor directories matching '" + pattern + "' in directory " + baseDir);
            }
            String[] testDirs = DefaultProjectBootstrapper.getListFromProperty(props, PROPERTY_TESTS);
            DefaultProjectBootstrapper.checkExistenceOfDirectories(projectId, baseDir, testDirs, PROPERTY_TESTS);
            String[] binDirs = DefaultProjectBootstrapper.getListFromProperty(props, PROPERTY_BINARIES);
            DefaultProjectBootstrapper.checkExistenceOfDirectories(projectId, baseDir, binDirs, PROPERTY_BINARIES);
        }
    }

    @VisibleForTesting
    protected static void cleanAndCheckProjectDefinitions(ProjectDefinition project) {
        if (project.getSubProjects().isEmpty()) {
            DefaultProjectBootstrapper.cleanAndCheckModuleProperties(project);
        } else {
            DefaultProjectBootstrapper.cleanAndCheckAggregatorProjectProperties(project);
            for (ProjectDefinition module : project.getSubProjects()) {
                DefaultProjectBootstrapper.cleanAndCheckProjectDefinitions(module);
            }
        }
    }

    @VisibleForTesting
    protected static void cleanAndCheckModuleProperties(ProjectDefinition project) {
        Properties properties = project.getProperties();
        String[] sourceDirs = DefaultProjectBootstrapper.getListFromProperty(properties, PROPERTY_SOURCES);
        DefaultProjectBootstrapper.checkExistenceOfDirectories(project.getKey(), project.getBaseDir(), sourceDirs, PROPERTY_SOURCES);
        ArrayList libPaths = Lists.newArrayList();
        for (String pattern : DefaultProjectBootstrapper.getListFromProperty(properties, PROPERTY_LIBRARIES)) {
            for (File file : DefaultProjectBootstrapper.getLibraries(project.getBaseDir(), pattern)) {
                libPaths.add(file.getAbsolutePath());
            }
        }
        properties.remove(PROPERTY_LIBRARIES);
        properties.put(PROPERTY_LIBRARIES, StringUtils.join((Collection)libPaths, (String)","));
    }

    @VisibleForTesting
    protected static void cleanAndCheckAggregatorProjectProperties(ProjectDefinition project) {
        String[] sourceDirs;
        Properties properties = project.getProperties();
        for (String path : sourceDirs = DefaultProjectBootstrapper.getListFromProperty(properties, PROPERTY_SOURCES)) {
            File sourceFolder = DefaultProjectBootstrapper.getFileFromPath(path, project.getBaseDir());
            if (!sourceFolder.isDirectory()) continue;
            LOG.warn("/!\\ A multi-module project can't have source folders, so '{}' won't be used for the analysis. If you want to analyse files of this folder, you should create another sub-module and move them inside it.", (Object)sourceFolder.toString());
        }
        properties.remove(PROPERTY_SOURCES);
        properties.remove(PROPERTY_TESTS);
        properties.remove(PROPERTY_BINARIES);
        properties.remove(PROPERTY_LIBRARIES);
        Properties clone = (Properties)properties.clone();
        ArrayList moduleIds = Lists.newArrayList((Object[])DefaultProjectBootstrapper.getListFromProperty(properties, PROPERTY_MODULES));
        for (Map.Entry<Object, Object> entry : clone.entrySet()) {
            String key = (String)entry.getKey();
            if (!DefaultProjectBootstrapper.isKeyPrefixedByModuleId(key, moduleIds)) continue;
            properties.remove(key);
        }
    }

    @VisibleForTesting
    protected static void replaceDeprecatedProperties(Properties props) {
        for (Map.Entry<String, String> entry : DEPRECATED_PROPS_TO_NEW_PROPS.entrySet()) {
            String key = entry.getKey();
            if (!props.containsKey(key)) continue;
            String newKey = entry.getValue();
            LOG.warn("/!\\ The '{}' property is deprecated and is replaced by '{}'. Don't forget to update your files.", (Object)key, (Object)newKey);
            String value = props.getProperty(key);
            props.remove(key);
            props.put(newKey, value);
        }
    }

    @VisibleForTesting
    protected static void mergeParentProperties(Properties childProps, Properties parentProps) {
        ArrayList moduleIds = Lists.newArrayList((Object[])DefaultProjectBootstrapper.getListFromProperty(parentProps, PROPERTY_MODULES));
        for (Map.Entry<Object, Object> entry : parentProps.entrySet()) {
            String key = (String)entry.getKey();
            if (childProps.containsKey(key) || NON_HERITED_PROPERTIES_FOR_CHILD.contains(key) || DefaultProjectBootstrapper.isKeyPrefixedByModuleId(key, moduleIds)) continue;
            childProps.put(entry.getKey(), entry.getValue());
        }
    }

    private static boolean isKeyPrefixedByModuleId(String key, List<String> moduleIds) {
        for (String moduleId : moduleIds) {
            if (!key.startsWith(moduleId + ".")) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected static Properties extractModuleProperties(String module, Properties properties) {
        Properties moduleProps = new Properties();
        String propertyPrefix = module + ".";
        int prefixLength = propertyPrefix.length();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(propertyPrefix)) continue;
            moduleProps.put(key.substring(prefixLength), entry.getValue());
        }
        return moduleProps;
    }

    @VisibleForTesting
    protected static void checkExistenceOfDirectories(String moduleRef, File baseDir, String[] sourceDirs, String propName) {
        for (String path : sourceDirs) {
            File sourceFolder = DefaultProjectBootstrapper.getFileFromPath(path, baseDir);
            if (sourceFolder.isDirectory()) continue;
            LOG.error("Invalid value of " + propName + " for " + moduleRef);
            throw new IllegalStateException("The folder '" + path + "' does not exist for '" + moduleRef + "' (base directory = " + baseDir.getAbsolutePath() + ")");
        }
    }

    @VisibleForTesting
    protected static File[] getLibraries(File baseDir, String pattern) {
        String filePattern;
        String dirPath;
        int i = Math.max(pattern.lastIndexOf(47), pattern.lastIndexOf(92));
        if (i == -1) {
            dirPath = ".";
            filePattern = pattern;
        } else {
            dirPath = pattern.substring(0, i);
            filePattern = pattern.substring(i + 1);
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        if (pattern.indexOf(42) >= 0) {
            filters.add(FileFileFilter.FILE);
        }
        filters.add(new WildcardFileFilter(filePattern));
        File dir = DefaultProjectBootstrapper.resolvePath(baseDir, dirPath);
        File[] files = dir.listFiles((FileFilter)new AndFileFilter(filters));
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    private static File resolvePath(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(baseDir, path).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to resolve path \"" + path + "\"", e);
            }
        }
        return file;
    }

    @VisibleForTesting
    protected static File getFileFromPath(String path, File baseDir) {
        File propertyFile = new File(path.trim());
        if (!propertyFile.isAbsolute()) {
            propertyFile = new File(baseDir, propertyFile.getPath());
        }
        return propertyFile;
    }

    static String[] getListFromProperty(Properties properties, String key) {
        return StringUtils.stripAll((String[])StringUtils.split((String)properties.getProperty(key, ""), (char)','));
    }
}

