/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.database.daos.MeasuresDao;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.FileExclusions;
import org.sonar.batch.DefaultProjectClasspath;
import org.sonar.batch.DefaultSensorContext;
import org.sonar.batch.DefaultTimeMachine;
import org.sonar.batch.ProfileProvider;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.bootstrap.BatchExtensionDictionnary;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.ExtensionMatcher;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.components.TimeMachineConfiguration;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.ResourcePersister;
import org.sonar.batch.issue.IssuableFactory;
import org.sonar.batch.issue.IssueFilters;
import org.sonar.batch.issue.ModuleIssues;
import org.sonar.batch.phases.PhaseExecutor;
import org.sonar.batch.phases.PhasesTimeProfiler;
import org.sonar.batch.scan.ModuleSettings;
import org.sonar.batch.scan.ProjectScanContainer;
import org.sonar.batch.scan.UnsupportedProperties;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.DeprecatedFileFilters;
import org.sonar.batch.scan.filesystem.ExclusionFilters;
import org.sonar.batch.scan.filesystem.FileHashes;
import org.sonar.batch.scan.filesystem.FileIndex;
import org.sonar.batch.scan.filesystem.FileSystemLogger;
import org.sonar.batch.scan.filesystem.LanguageRecognizer;
import org.sonar.batch.scan.filesystem.ModuleFileSystemInitializer;
import org.sonar.batch.scan.filesystem.ProjectFileSystemAdapter;
import org.sonar.batch.scan.filesystem.RemoteFileHashes;
import org.sonar.batch.scan.report.ComponentSelectorFactory;
import org.sonar.batch.scan.report.JsonReport;
import org.sonar.core.component.ScanPerspectives;
import org.sonar.core.measure.MeasurementFilters;

public class ModuleScanContainer
extends ComponentContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleScanContainer.class);
    private final Project module;

    public ModuleScanContainer(ProjectScanContainer parent, Project module) {
        super((ComponentContainer)parent);
        this.module = module;
    }

    protected void doBeforeStart() {
        LOG.info("-------------  Scan {}", (Object)this.module.getName());
        this.addCoreComponents();
        this.addExtensions();
    }

    private void addCoreComponents() {
        ProjectDefinition moduleDefinition = ((ProjectTree)this.getComponentByType(ProjectTree.class)).getProjectDefinition(this.module);
        this.add(new Object[]{moduleDefinition, this.module.getConfiguration(), this.module, ModuleSettings.class});
        this.getComponentByType(ModuleSettings.class);
        this.add(new Object[]{EventBus.class, PhaseExecutor.class, PhasesTimeProfiler.class, UnsupportedProperties.class, PhaseExecutor.getPhaseClasses(), moduleDefinition.getContainerExtensions(), Languages.class, FileExclusions.class, ExclusionFilters.class, DeprecatedFileFilters.class, FileHashes.class, RemoteFileHashes.class, FileIndex.class, LanguageRecognizer.class, FileSystemLogger.class, DefaultProjectClasspath.class, DefaultModuleFileSystem.class, ModuleFileSystemInitializer.class, ProjectFileSystemAdapter.class, ((ResourcePersister)this.getComponentByType(ResourcePersister.class)).getSnapshot((Resource)this.module), TimeMachineConfiguration.class, MeasuresDao.class, DefaultSensorContext.class, BatchExtensionDictionnary.class, DefaultTimeMachine.class, ViolationFilters.class, IssueFilters.class, MeasurementFilters.class, ResourceFilters.class, new ProfileProvider(), JsonReport.class, ComponentSelectorFactory.class, IssuableFactory.class, ModuleIssues.class, ScanPerspectives.class});
    }

    private void addExtensions() {
        ExtensionInstaller installer = (ExtensionInstaller)this.getComponentByType(ExtensionInstaller.class);
        installer.install(this, new ExtensionMatcher(){

            @Override
            public boolean accept(Object extension) {
                if (ExtensionUtils.isType(extension, BatchExtension.class) && ExtensionUtils.isInstantiationStrategy(extension, "PER_PROJECT")) {
                    return !ExtensionUtils.isMavenExtensionOnly(extension) || ModuleScanContainer.this.module.getPom() != null;
                }
                return false;
            }
        });
    }

    protected void doAfterStart() {
        DefaultIndex index = (DefaultIndex)((Object)this.getComponentByType(DefaultIndex.class));
        index.setCurrentProject(this.module, (ResourceFilters)this.getComponentByType(ResourceFilters.class), (ModuleIssues)this.getComponentByType(ModuleIssues.class));
        ((PhaseExecutor)this.getComponentByType(PhaseExecutor.class)).execute(this.module);
    }
}

