/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.picocontainer.Startable;
import org.sonar.api.BatchComponent;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.PastSnapshotFinder;
import org.sonar.core.source.jdbc.SnapshotDataDao;
import org.sonar.core.source.jdbc.SnapshotDataDto;

public class RemoteFileHashes
implements BatchComponent,
Startable {
    private final SnapshotDataDao dao;
    private final PastSnapshotFinder pastSnapshotFinder;
    private final Snapshot snapshot;
    private Map<String, String> pathToHash = Maps.newHashMap();

    public RemoteFileHashes(Snapshot snapshot, SnapshotDataDao dao, PastSnapshotFinder pastSnapshotFinder) {
        this.snapshot = snapshot;
        this.dao = dao;
        this.pastSnapshotFinder = pastSnapshotFinder;
    }

    public void start() {
        Collection selectSnapshotData;
        PastSnapshot pastSnapshot = this.pastSnapshotFinder.findPreviousAnalysis(this.snapshot);
        if (pastSnapshot.isRelatedToSnapshot() && !(selectSnapshotData = this.dao.selectSnapshotData(pastSnapshot.getProjectSnapshot().getId().longValue(), Arrays.asList("file_hashes"))).isEmpty()) {
            SnapshotDataDto snapshotDataDto = (SnapshotDataDto)selectSnapshotData.iterator().next();
            String data = snapshotDataDto.getData();
            this.pathToHash = KeyValueFormat.parse((String)data);
        }
    }

    @CheckForNull
    public String remoteHash(String baseRelativePath) {
        return this.pathToHash.get(baseRelativePath);
    }

    public void stop() {
    }
}

