/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.tasks;

import org.sonar.api.task.Task;
import org.sonar.api.task.TaskDefinition;
import org.sonar.batch.tasks.Tasks;

public class ListTask
implements Task {
    public static final String KEY = "list";
    public static final TaskDefinition DEFINITION = TaskDefinition.builder().key("list").description("List available tasks").taskClass(ListTask.class).build();
    private final Tasks tasks;

    public ListTask(Tasks tasks) {
        this.tasks = tasks;
    }

    public void execute() {
        this.logBlankLine();
        this.log("Available tasks:");
        this.logBlankLine();
        for (TaskDefinition def : this.tasks.definitions()) {
            this.log("  - " + def.key() + ": " + def.description());
        }
        this.logBlankLine();
    }

    void log(String s) {
        System.out.println(s);
    }

    void logBlankLine() {
        System.out.println();
    }
}

