/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.sonar.api.Plugin;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.Durations;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.UriReader;
import org.sonar.api.utils.internal.TempFolderCleaner;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.BatchDatabase;
import org.sonar.batch.bootstrap.BatchDatabaseSessionFactory;
import org.sonar.batch.bootstrap.BatchPluginJarInstaller;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.BatchSettings;
import org.sonar.batch.bootstrap.BootstrapProperties;
import org.sonar.batch.bootstrap.DatabaseCompatibility;
import org.sonar.batch.bootstrap.DefaultPluginsReferential;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.FileCacheProvider;
import org.sonar.batch.bootstrap.JdbcDriverHolder;
import org.sonar.batch.bootstrap.PluginsReferential;
import org.sonar.batch.bootstrap.PreviewDatabase;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.batch.bootstrap.ServerMetadata;
import org.sonar.batch.bootstrap.TaskContainer;
import org.sonar.batch.bootstrap.TempFolderProvider;
import org.sonar.batch.components.PastMeasuresLoader;
import org.sonar.batch.components.PastSnapshotFinder;
import org.sonar.batch.components.PastSnapshotFinderByDate;
import org.sonar.batch.components.PastSnapshotFinderByDays;
import org.sonar.batch.components.PastSnapshotFinderByPreviousAnalysis;
import org.sonar.batch.components.PastSnapshotFinderByPreviousVersion;
import org.sonar.batch.components.PastSnapshotFinderByVersion;
import org.sonar.batch.debt.DebtModelProvider;
import org.sonar.batch.rule.RulesProvider;
import org.sonar.batch.rules.DefaultQProfileReferential;
import org.sonar.batch.rules.QProfilesReferential;
import org.sonar.batch.settings.DefaultSettingsReferential;
import org.sonar.batch.settings.SettingsReferential;
import org.sonar.core.cluster.NullQueue;
import org.sonar.core.config.Logback;
import org.sonar.core.i18n.DefaultI18n;
import org.sonar.core.i18n.RuleI18nManager;
import org.sonar.core.metric.CacheMetricFinder;
import org.sonar.core.persistence.DaoUtils;
import org.sonar.core.persistence.DatabaseVersion;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.persistence.SemaphoreUpdater;
import org.sonar.core.persistence.SemaphoresImpl;
import org.sonar.core.purge.PurgeProfiler;
import org.sonar.core.rule.CacheRuleFinder;
import org.sonar.core.user.HibernateUserFinder;
import org.sonar.jpa.dao.MeasuresDao;
import org.sonar.jpa.session.DefaultDatabaseConnector;
import org.sonar.jpa.session.JpaDatabaseSession;

public class BootstrapContainer
extends ComponentContainer {
    private final Map<String, String> bootstrapProperties;
    private final boolean sensorMode;

    private BootstrapContainer(Map<String, String> bootstrapProperties) {
        this.sensorMode = "sensor".equals(bootstrapProperties.get("sonar.analysis.mode"));
        this.bootstrapProperties = bootstrapProperties;
    }

    public static BootstrapContainer create(Map<String, String> bootstrapProperties, List extensions) {
        BootstrapContainer container = new BootstrapContainer(bootstrapProperties);
        container.add(new Object[]{extensions});
        return container;
    }

    protected void doBeforeStart() {
        this.addBootstrapComponents();
        if (!this.sensorMode) {
            this.addDatabaseComponents();
            this.addCoreComponents();
        }
    }

    private void addBootstrapComponents() {
        this.add(new Object[]{new PropertiesConfiguration(), new BootstrapProperties(this.bootstrapProperties), AnalysisMode.class, BatchPluginRepository.class, BatchPluginJarInstaller.class, BatchSettings.class, ServerClient.class, ExtensionInstaller.class, Logback.class, ServerMetadata.class, org.sonar.batch.ServerMetadata.class, new TempFolderProvider(), TempFolderCleaner.class, HttpDownloader.class, UriReader.class, new FileCacheProvider(), System2.INSTANCE});
        if (this.getComponentByType(SettingsReferential.class) == null) {
            this.add(new Object[]{DefaultSettingsReferential.class});
        }
        if (this.getComponentByType(PluginsReferential.class) == null) {
            this.add(new Object[]{DefaultPluginsReferential.class});
        }
        if (this.getComponentByType(RuleFinder.class) == null) {
            this.add(new Object[]{CacheRuleFinder.class});
        }
        if (this.getComponentByType(MetricFinder.class) == null) {
            this.add(new Object[]{CacheMetricFinder.class});
        }
        if (this.getComponentByType(QProfilesReferential.class) == null) {
            this.add(new Object[]{DefaultQProfileReferential.class});
        }
    }

    private void addDatabaseComponents() {
        this.add(new Object[]{PreviewDatabase.class, JdbcDriverHolder.class, BatchDatabase.class, MyBatis.class, NullQueue.class, DatabaseVersion.class, DatabaseCompatibility.class, DefaultDatabaseConnector.class, JpaDatabaseSession.class, BatchDatabaseSessionFactory.class, DaoUtils.getDaoClasses(), PurgeProfiler.class});
    }

    private void addCoreComponents() {
        this.add(new Object[]{EmailSettings.class, DefaultI18n.class, RuleI18nManager.class, MeasuresDao.class, HibernateUserFinder.class, SemaphoreUpdater.class, SemaphoresImpl.class, PastSnapshotFinderByDate.class, PastSnapshotFinderByDays.class, PastSnapshotFinderByPreviousAnalysis.class, PastSnapshotFinderByVersion.class, PastSnapshotFinderByPreviousVersion.class, PastMeasuresLoader.class, PastSnapshotFinder.class, Durations.class, new DebtModelProvider(), new RulesProvider()});
    }

    protected void doAfterStart() {
        this.installPlugins();
    }

    private void installPlugins() {
        for (Map.Entry<PluginMetadata, Plugin> entry : ((BatchPluginRepository)this.getComponentByType(BatchPluginRepository.class)).getPluginsByMetadata().entrySet()) {
            PluginMetadata metadata = entry.getKey();
            Plugin plugin = entry.getValue();
            this.addExtension(metadata, plugin);
        }
    }

    public void executeTask(Map<String, String> taskProperties, Object ... components) {
        new TaskContainer(this, taskProperties, components).execute();
    }
}

