/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonar.batch.bootstrap.BootstrapContainer;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.bootstrapper.LoggingConfiguration;

public final class Batch {
    private boolean started = false;
    private LoggingConfiguration logging;
    private List<Object> components;
    private Map<String, String> bootstrapProperties = Maps.newHashMap();
    private BootstrapContainer bootstrapContainer;

    private Batch(Builder builder) {
        this.components = Lists.newArrayList();
        this.components.addAll(builder.components);
        if (builder.environment != null) {
            this.components.add(builder.environment);
        }
        if (builder.bootstrapProperties != null) {
            this.bootstrapProperties.putAll(builder.bootstrapProperties);
        }
        if (builder.isEnableLoggingConfiguration()) {
            this.logging = LoggingConfiguration.create(builder.environment).setProperties(this.bootstrapProperties);
        }
    }

    public LoggingConfiguration getLoggingConfiguration() {
        return this.logging;
    }

    @Deprecated
    public synchronized Batch execute() {
        this.configureLogging();
        this.start().executeTask(this.bootstrapProperties, new Object[0]).stop();
        return this;
    }

    public synchronized Batch start() {
        if (this.started) {
            throw new IllegalStateException("Batch is already started");
        }
        this.configureLogging();
        this.bootstrapContainer = BootstrapContainer.create(this.bootstrapProperties, this.components);
        this.bootstrapContainer.startComponents();
        this.started = true;
        return this;
    }

    public Batch executeTask(Map<String, String> taskProperties, Object ... components) {
        if (!this.started) {
            throw new IllegalStateException("Batch is not started. Unable to execute task.");
        }
        this.bootstrapContainer.executeTask(taskProperties, components);
        return this;
    }

    public synchronized void stop() {
        if (!this.started) {
            throw new IllegalStateException("Batch is not started.");
        }
        this.bootstrapContainer.stopComponents();
        this.started = false;
    }

    private void configureLogging() {
        if (this.logging != null) {
            this.logging.configure();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, String> bootstrapProperties;
        private EnvironmentInformation environment;
        private List<Object> components = Lists.newArrayList();
        private boolean enableLoggingConfiguration = true;

        private Builder() {
        }

        public Builder setEnvironment(EnvironmentInformation env) {
            this.environment = env;
            return this;
        }

        public Builder setComponents(List<Object> l) {
            this.components = l;
            return this;
        }

        @Deprecated
        public Builder setGlobalProperties(Map<String, String> globalProperties) {
            this.bootstrapProperties = globalProperties;
            return this;
        }

        public Builder setBootstrapProperties(Map<String, String> bootstrapProperties) {
            this.bootstrapProperties = bootstrapProperties;
            return this;
        }

        public Builder addComponents(Object ... components) {
            Collections.addAll(this.components, components);
            return this;
        }

        public Builder addComponent(Object component) {
            this.components.add(component);
            return this;
        }

        public boolean isEnableLoggingConfiguration() {
            return this.enableLoggingConfiguration;
        }

        public Builder setEnableLoggingConfiguration(boolean b) {
            this.enableLoggingConfiguration = b;
            return this;
        }

        public Batch build() {
            if (this.components == null) {
                throw new IllegalStateException("Batch components are not set");
            }
            return new Batch(this);
        }
    }
}

