/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.debt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.technicaldebt.batch.Characteristic;
import org.sonar.api.technicaldebt.batch.TechnicalDebtModel;
import org.sonar.api.technicaldebt.batch.internal.DefaultCharacteristic;

@DependsUpon(value={"END_OF_VIOLATION_TRACKING"})
public final class DebtDecorator
implements Decorator {
    private final ResourcePerspectives perspectives;
    private final TechnicalDebtModel model;
    private final Rules rules;
    private final RuleFinder ruleFinder;

    public DebtDecorator(ResourcePerspectives perspectives, TechnicalDebtModel model, Rules rules, RuleFinder ruleFinder) {
        this.perspectives = perspectives;
        this.model = model;
        this.rules = rules;
        this.ruleFinder = ruleFinder;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependedUpon
    public List<Metric> generatesMetrics() {
        return Arrays.asList(CoreMetrics.TECHNICAL_DEBT);
    }

    public void decorate(Resource resource, DecoratorContext context) {
        Issuable issuable = (Issuable)this.perspectives.as(Issuable.class, resource);
        if (issuable != null && this.shouldSaveMeasure(context)) {
            ArrayList issues = Lists.newArrayList((Iterable)issuable.issues());
            this.saveMeasures(context, issues);
        }
    }

    private void saveMeasures(DecoratorContext context, List<Issue> issues) {
        Long debt;
        Long total = 0L;
        SumMap<RuleKey> ruleDebts = new SumMap<RuleKey>();
        SumMap<Characteristic> characteristicDebts = new SumMap<Characteristic>();
        for (Issue issue : issues) {
            debt = ((DefaultIssue)issue).debtInMinutes();
            total = total + this.computeDebt(debt, issue.ruleKey(), ruleDebts, characteristicDebts);
        }
        for (Measure measure : context.getChildrenMeasures(MeasuresFilters.rules((Metric)CoreMetrics.TECHNICAL_DEBT))) {
            debt = measure.getValue().longValue();
            RuleMeasure ruleMeasure = (RuleMeasure)measure;
            total = total + this.computeDebt(debt, ruleMeasure.ruleKey(), ruleDebts, characteristicDebts);
        }
        context.saveMeasure(CoreMetrics.TECHNICAL_DEBT, Double.valueOf(total.doubleValue()));
        this.saveOnRule(context, ruleDebts);
        Iterator<Object> i$ = this.model.characteristics().iterator();
        while (i$.hasNext()) {
            DefaultCharacteristic characteristic;
            debt = characteristicDebts.get((Characteristic)(characteristic = (DefaultCharacteristic)i$.next()));
            this.saveCharacteristicMeasure(context, (Characteristic)characteristic, debt != null ? debt.doubleValue() : 0.0, false);
        }
    }

    private Long computeDebt(@Nullable Long debt, RuleKey ruleKey, SumMap<RuleKey> ruleDebts, SumMap<Characteristic> characteristicDebts) {
        Characteristic characteristic;
        String characteristicKey;
        Rule rule;
        if (debt != null && (rule = this.rules.find(ruleKey)) != null && (characteristicKey = rule.debtSubCharacteristic()) != null && (characteristic = this.model.characteristicByKey(characteristicKey)) != null) {
            ruleDebts.add(ruleKey, debt);
            characteristicDebts.add(characteristic, debt);
            this.propagateTechnicalDebtInParents(characteristic.parent(), debt, characteristicDebts);
            return debt;
        }
        return 0L;
    }

    private void propagateTechnicalDebtInParents(@Nullable Characteristic characteristic, long value, SumMap<Characteristic> characteristicDebts) {
        if (characteristic != null) {
            characteristicDebts.add(characteristic, value);
            this.propagateTechnicalDebtInParents(characteristic.parent(), value, characteristicDebts);
        }
    }

    private void saveOnRule(DecoratorContext context, SumMap<RuleKey> ruleDebts) {
        for (Map.Entry<RuleKey, Long> entry : ruleDebts.entrySet()) {
            org.sonar.api.rules.Rule oldRule = this.ruleFinder.findByKey(entry.getKey());
            if (oldRule == null) continue;
            this.saveRuleMeasure(context, oldRule, entry.getValue().doubleValue(), ResourceUtils.isEntity((Resource)context.getResource()));
        }
    }

    @VisibleForTesting
    void saveCharacteristicMeasure(DecoratorContext context, Characteristic characteristic, Double value, boolean inMemory) {
        if (value > 0.0 || ResourceUtils.isProject((Resource)context.getResource()) && characteristic.isRoot()) {
            Measure measure = new Measure(CoreMetrics.TECHNICAL_DEBT);
            measure.setCharacteristic(characteristic);
            this.saveMeasure(context, measure, value, inMemory);
        }
    }

    @VisibleForTesting
    void saveRuleMeasure(DecoratorContext context, org.sonar.api.rules.Rule rule, Double value, boolean inMemory) {
        if (value > 0.0) {
            RuleMeasure measure = new RuleMeasure(CoreMetrics.TECHNICAL_DEBT, rule, null, null);
            this.saveMeasure(context, (Measure)measure, value, inMemory);
        }
    }

    private void saveMeasure(DecoratorContext context, Measure measure, Double value, boolean inMemory) {
        measure.setValue(value);
        if (inMemory) {
            measure.setPersistenceMode(PersistenceMode.MEMORY);
        }
        context.saveMeasure(measure);
    }

    private boolean shouldSaveMeasure(DecoratorContext context) {
        return context.getMeasure(CoreMetrics.TECHNICAL_DEBT) == null;
    }

    private static class SumMap<E> {
        private Map<E, Long> sumByKeys = Maps.newHashMap();

        public void add(@Nullable E key, Long value) {
            if (key != null) {
                Long currentValue = this.sumByKeys.get(key);
                this.sumByKeys.put(key, currentValue != null ? currentValue + value : value);
            }
        }

        @CheckForNull
        public Long get(E key) {
            return this.sumByKeys.get(key);
        }

        public Set<Map.Entry<E, Long>> entrySet() {
            return this.sumByKeys.entrySet();
        }
    }
}

