/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.debt;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.issue.internal.FieldDiffs;

public class IssueChangelogDebtCalculator
implements BatchComponent {
    @CheckForNull
    public Long calculateNewTechnicalDebt(Issue issue, @Nullable Date periodDate) {
        Date periodDatePlusOneSecond;
        Long debt = ((DefaultIssue)issue).debtInMinutes();
        Date date = periodDatePlusOneSecond = periodDate != null ? DateUtils.addSeconds((Date)periodDate, (int)1) : null;
        if (this.isAfter(issue.creationDate(), periodDatePlusOneSecond)) {
            return debt;
        }
        return this.calculateNewTechnicalDebtValueFromChangelog(debt, issue, periodDate);
    }

    @CheckForNull
    private Long calculateNewTechnicalDebtValueFromChangelog(@Nullable Long currentTechnicalDebtValue, Issue issue, Date periodDate) {
        List<FieldDiffs> changelog = this.technicalDebtHistory(issue);
        Iterator<FieldDiffs> iterator = changelog.iterator();
        while (iterator.hasNext()) {
            FieldDiffs diff = iterator.next();
            Date date = diff.creationDate();
            if (this.isLesserOrEqual(date, periodDate)) {
                return this.subtractNeverNegative(currentTechnicalDebtValue, this.newValue(diff));
            }
            if (iterator.hasNext()) continue;
            return this.subtractNeverNegative(currentTechnicalDebtValue, this.oldValue(diff));
        }
        return null;
    }

    @CheckForNull
    private Long subtractNeverNegative(@Nullable Long value, Long with) {
        Long result = (value != null ? value : 0L) - (with != null ? with : 0L);
        return result > 0L ? result : null;
    }

    private List<FieldDiffs> technicalDebtHistory(Issue issue) {
        List<FieldDiffs> technicalDebtChangelog = this.changesOnField(((DefaultIssue)issue).changes());
        if (!technicalDebtChangelog.isEmpty()) {
            Ordering ordering = Ordering.natural().reverse().nullsFirst().onResultOf((Function)new Function<FieldDiffs, Date>(){

                public Date apply(FieldDiffs diff) {
                    return diff.creationDate();
                }
            });
            return ordering.immutableSortedCopy(technicalDebtChangelog);
        }
        return Collections.emptyList();
    }

    private List<FieldDiffs> changesOnField(Collection<FieldDiffs> fieldDiffs) {
        ArrayList diffs = Lists.newArrayList();
        for (FieldDiffs fieldDiff : fieldDiffs) {
            if (!fieldDiff.diffs().containsKey("technicalDebt")) continue;
            diffs.add(fieldDiff);
        }
        return diffs;
    }

    @CheckForNull
    private Long newValue(FieldDiffs fieldDiffs) {
        for (Map.Entry entry : fieldDiffs.diffs().entrySet()) {
            if (!((String)entry.getKey()).equals("technicalDebt")) continue;
            return ((FieldDiffs.Diff)entry.getValue()).newValueLong();
        }
        return null;
    }

    @CheckForNull
    private Long oldValue(FieldDiffs fieldDiffs) {
        for (Map.Entry entry : fieldDiffs.diffs().entrySet()) {
            if (!((String)entry.getKey()).equals("technicalDebt")) continue;
            return ((FieldDiffs.Diff)entry.getValue()).oldValueLong();
        }
        return null;
    }

    private boolean isAfter(@Nullable Date currentDate, @Nullable Date pastDate) {
        return pastDate == null || currentDate != null && DateUtils.truncatedCompareTo((Date)currentDate, (Date)pastDate, (int)13) > 0;
    }

    private boolean isLesserOrEqual(@Nullable Date currentDate, @Nullable Date pastDate) {
        return currentDate != null && (pastDate == null || DateUtils.truncatedCompareTo((Date)currentDate, (Date)pastDate, (int)13) <= 0);
    }
}

