/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.sonar.api.batch.debt.DebtRemediationFunction;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.issue.IssueCache;
import org.sonar.batch.issue.IssueFilters;
import org.sonar.core.issue.DefaultIssueBuilder;

public class ModuleIssues {
    private final ActiveRules activeRules;
    private final Rules rules;
    private final IssueCache cache;
    private final Project project;
    private final IssueFilters filters;

    public ModuleIssues(ActiveRules activeRules, Rules rules, IssueCache cache, @Nullable Project project, IssueFilters filters) {
        this.activeRules = activeRules;
        this.rules = rules;
        this.cache = cache;
        this.project = project;
        this.filters = filters;
    }

    public ModuleIssues(ActiveRules activeRules, Rules rules, IssueCache cache, IssueFilters filters) {
        this(activeRules, rules, cache, null, filters);
    }

    public boolean initAndAddIssue(DefaultIssue issue) {
        return this.initAndAddIssue(issue, null);
    }

    public boolean initAndAddViolation(Violation violation) {
        DefaultIssue issue = this.newIssue(violation);
        return this.initAndAddIssue(issue, violation);
    }

    private DefaultIssue newIssue(Violation violation) {
        return new DefaultIssueBuilder().componentKey(violation.getResource().getEffectiveKey()).projectKey(this.project.getRoot().getEffectiveKey()).ruleKey(RuleKey.of((String)violation.getRule().getRepositoryKey(), (String)violation.getRule().getKey())).effortToFix(violation.getCost()).line(violation.getLineId()).message(violation.getMessage()).severity(violation.getSeverity() != null ? violation.getSeverity().name() : null).build();
    }

    private boolean initAndAddIssue(DefaultIssue issue, @Nullable Violation violation) {
        RuleKey ruleKey = issue.ruleKey();
        Rule rule = this.rules.find(ruleKey);
        this.validateRule(issue, rule);
        ActiveRule activeRule = this.activeRules.find(ruleKey);
        if (activeRule == null) {
            return false;
        }
        this.updateIssue(issue, rule, activeRule);
        if (this.filters.accept(issue, violation)) {
            this.cache.put(issue);
            return true;
        }
        return false;
    }

    private void validateRule(DefaultIssue issue, Rule rule) {
        RuleKey ruleKey = issue.ruleKey();
        if (rule == null) {
            throw MessageException.of((String)String.format("The rule '%s' does not exist.", ruleKey));
        }
        if (Strings.isNullOrEmpty((String)rule.name()) && Strings.isNullOrEmpty((String)issue.message())) {
            throw MessageException.of((String)String.format("The rule '%s' has no name and the related issue has no message.", ruleKey));
        }
    }

    private void updateIssue(DefaultIssue issue, Rule rule, ActiveRule activeRule) {
        if (Strings.isNullOrEmpty((String)issue.message())) {
            issue.setMessage(rule.name());
        }
        if (this.project != null) {
            issue.setCreationDate(this.project.getAnalysisDate());
            issue.setUpdateDate(this.project.getAnalysisDate());
        }
        if (issue.severity() == null) {
            issue.setSeverity(activeRule.severity());
        }
        DebtRemediationFunction function = rule.debtRemediationFunction();
        if (rule.debtSubCharacteristic() != null && function != null) {
            issue.setDebt(this.calculateDebt(function, issue.effortToFix(), rule.key()));
        }
    }

    private Duration calculateDebt(DebtRemediationFunction function, @Nullable Double effortToFix, RuleKey ruleKey) {
        if (DebtRemediationFunction.Type.CONSTANT_ISSUE.equals((Object)function.type()) && effortToFix != null) {
            throw new IllegalArgumentException("Rule '" + ruleKey + "' can not use 'Constant/issue' remediation function " + "because this rule does not have a fixed remediation cost.");
        }
        Duration result = Duration.create((long)0L);
        Duration factor = function.coefficient();
        Duration offset = function.offset();
        if (factor != null) {
            int effortToFixValue = ((Number)Objects.firstNonNull((Object)effortToFix, (Object)1)).intValue();
            result = factor.multiply(effortToFixValue);
        }
        if (offset != null) {
            result = result.add(offset);
        }
        return result;
    }
}

