/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue.ignore;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.batch.IssueFilter;
import org.sonar.api.issue.batch.IssueFilterChain;
import org.sonar.batch.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonar.batch.issue.ignore.pattern.IssuePattern;

public class EnforceIssuesFilter
implements IssueFilter {
    private IssueInclusionPatternInitializer patternInitializer;
    private static final Logger LOG = LoggerFactory.getLogger(EnforceIssuesFilter.class);

    public EnforceIssuesFilter(IssueInclusionPatternInitializer patternInitializer) {
        this.patternInitializer = patternInitializer;
    }

    public boolean accept(Issue issue, IssueFilterChain chain) {
        boolean atLeastOneRuleMatched = false;
        boolean atLeastOnePatternFullyMatched = false;
        IssuePattern matchingPattern = null;
        for (IssuePattern pattern : this.patternInitializer.getMulticriteriaPatterns()) {
            if (!pattern.getRulePattern().match(issue.ruleKey().toString())) continue;
            atLeastOneRuleMatched = true;
            String pathForComponent = this.patternInitializer.getPathForComponent(issue.componentKey());
            if (pathForComponent == null || !pattern.getResourcePattern().match(pathForComponent)) continue;
            atLeastOnePatternFullyMatched = true;
            matchingPattern = pattern;
        }
        if (atLeastOneRuleMatched) {
            if (atLeastOnePatternFullyMatched) {
                LOG.debug("Issue {} enforced by pattern {}", (Object)issue, matchingPattern);
            }
            return atLeastOnePatternFullyMatched;
        }
        return chain.accept(issue);
    }
}

