/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue.ignore.pattern;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.issue.Issue;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.batch.issue.ignore.pattern.LineRange;

public class IssuePattern {
    private WildcardPattern resourcePattern;
    private WildcardPattern rulePattern;
    private Set<Integer> lines = Sets.newLinkedHashSet();
    private Set<LineRange> lineRanges = Sets.newLinkedHashSet();
    private String beginBlockRegexp;
    private String endBlockRegexp;
    private String allFileRegexp;
    private boolean checkLines = true;

    public IssuePattern() {
    }

    public IssuePattern(String resourcePattern, String rulePattern) {
        this.resourcePattern = WildcardPattern.create((String)resourcePattern);
        this.rulePattern = WildcardPattern.create((String)rulePattern);
    }

    public IssuePattern(String resourcePattern, String rulePattern, Set<LineRange> lineRanges) {
        this(resourcePattern, rulePattern);
        this.lineRanges = lineRanges;
    }

    public WildcardPattern getResourcePattern() {
        return this.resourcePattern;
    }

    public WildcardPattern getRulePattern() {
        return this.rulePattern;
    }

    public String getBeginBlockRegexp() {
        return this.beginBlockRegexp;
    }

    public String getEndBlockRegexp() {
        return this.endBlockRegexp;
    }

    public String getAllFileRegexp() {
        return this.allFileRegexp;
    }

    IssuePattern addLineRange(int fromLineId, int toLineId) {
        this.lineRanges.add(new LineRange(fromLineId, toLineId));
        return this;
    }

    IssuePattern addLine(int lineId) {
        this.lines.add(lineId);
        return this;
    }

    boolean isCheckLines() {
        return this.checkLines;
    }

    IssuePattern setCheckLines(boolean b) {
        this.checkLines = b;
        return this;
    }

    IssuePattern setBeginBlockRegexp(String beginBlockRegexp) {
        this.beginBlockRegexp = beginBlockRegexp;
        return this;
    }

    IssuePattern setEndBlockRegexp(String endBlockRegexp) {
        this.endBlockRegexp = endBlockRegexp;
        return this;
    }

    IssuePattern setAllFileRegexp(String allFileRegexp) {
        this.allFileRegexp = allFileRegexp;
        return this;
    }

    Set<Integer> getAllLines() {
        LinkedHashSet allLines = Sets.newLinkedHashSet(this.lines);
        for (LineRange lineRange : this.lineRanges) {
            allLines.addAll(lineRange.toLines());
        }
        return allLines;
    }

    public boolean match(Issue issue) {
        boolean match;
        boolean bl = match = this.matchResource(issue.componentKey()) && this.matchRule(issue.ruleKey());
        if (this.checkLines) {
            Integer line = issue.line();
            match = line == null ? false : match && this.matchLine(line);
        }
        return match;
    }

    boolean matchLine(int lineId) {
        if (this.lines.contains(lineId)) {
            return true;
        }
        for (LineRange range : this.lineRanges) {
            if (!range.in(lineId)) continue;
            return true;
        }
        return false;
    }

    boolean matchRule(RuleKey rule) {
        if (rule == null) {
            return false;
        }
        String key = rule.repository() + ':' + rule.rule();
        return this.rulePattern.match(key);
    }

    boolean matchResource(String resource) {
        return resource != null && this.resourcePattern.match(resource);
    }

    public IssuePattern forResource(String resource) {
        return new IssuePattern(resource, this.rulePattern.toString(), this.lineRanges).setCheckLines(this.isCheckLines());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

