/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.language;

import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.CountDistributionBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;

public class LanguageDistributionDecorator
implements Decorator {
    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependsUpon
    public Metric dependsUponMetric() {
        return CoreMetrics.LINES;
    }

    @DependedUpon
    public Metric generatesMetric() {
        return CoreMetrics.NCLOC_LANGUAGE_DISTRIBUTION;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        CountDistributionBuilder nclocDistribution = new CountDistributionBuilder(CoreMetrics.NCLOC_LANGUAGE_DISTRIBUTION);
        if (ResourceUtils.isFile((Resource)resource)) {
            Language language = resource.getLanguage();
            Measure ncloc = context.getMeasure(CoreMetrics.NCLOC);
            if (language != null && ncloc != null) {
                nclocDistribution.add((Object)language.getKey(), ncloc.getIntValue().intValue());
            }
        } else {
            for (Measure measure : context.getChildrenMeasures(CoreMetrics.NCLOC_LANGUAGE_DISTRIBUTION)) {
                nclocDistribution.add(measure);
            }
        }
        Measure measure = nclocDistribution.build(false);
        if (measure != null) {
            context.saveMeasure(measure);
        }
    }
}

