/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.maven;

import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.batch.maven.MavenProjectConverter;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.maven.MavenPluginExecutor;

@SupportedEnvironment(value={"maven"})
public class DefaultMavenPluginExecutor
implements MavenPluginExecutor {
    private final MavenProjectConverter pomConverter;
    private LifecycleExecutor lifecycleExecutor;
    private MavenSession mavenSession;

    public DefaultMavenPluginExecutor(LifecycleExecutor le, MavenSession mavenSession, MavenProjectConverter pomConverter) {
        this.lifecycleExecutor = le;
        this.mavenSession = mavenSession;
        this.pomConverter = pomConverter;
    }

    @Override
    public final MavenPluginHandler execute(Project project, DefaultModuleFileSystem fs, MavenPluginHandler handler) {
        for (String goal : handler.getGoals()) {
            if (goal == null) {
                throw new IllegalStateException("Maven goal can't be null");
            }
            MavenPlugin plugin = MavenPlugin.getPlugin((MavenProject)project.getPom(), (String)handler.getGroupId(), (String)handler.getArtifactId());
            this.execute(project, fs, DefaultMavenPluginExecutor.getGoal(handler.getGroupId(), handler.getArtifactId(), plugin != null && plugin.getPlugin() != null ? plugin.getPlugin().getVersion() : null, goal));
        }
        return handler;
    }

    @Override
    public final void execute(Project project, DefaultModuleFileSystem fs, String goal) {
        if (project.getPom() != null) {
            TimeProfiler profiler = new TimeProfiler().start("Execute " + goal);
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                this.concreteExecute(project.getPom(), goal);
            }
            catch (Exception e) {
                throw new SonarException("Unable to execute maven plugin", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                profiler.stop();
            }
            if (!fs.isInitialized()) {
                this.pomConverter.synchronizeFileSystem(project.getPom(), fs);
            }
        }
    }

    static String getGoal(String groupId, String artifactId, @Nullable String version, String goal) {
        String defaultVersion = version == null ? "" : version;
        return groupId + ":" + artifactId + ":" + defaultVersion + ":" + goal;
    }

    public void concreteExecute(MavenProject pom, String goal) {
        Method executeMethod = null;
        for (Method m : this.lifecycleExecutor.getClass().getMethods()) {
            if (!"execute".equals(m.getName())) continue;
            executeMethod = m;
            break;
        }
        if (executeMethod == null) {
            throw new SonarException("Unable to find execute method on Maven LifecycleExecutor. Please check your Maven version.");
        }
        if (executeMethod.getParameterTypes().length == 1) {
            this.concreteExecuteMaven3(pom, goal);
        } else if (executeMethod.getParameterTypes().length == 3) {
            this.concreteExecuteMaven2(executeMethod, pom, goal);
        } else {
            throw new SonarException("Unexpected parameter count on Maven LifecycleExecutor#execute method. Please check your Maven version.");
        }
    }

    public void concreteExecuteMaven3(MavenProject pom, String goal) {
        MavenSession projectSession = this.mavenSession.clone();
        projectSession.setCurrentProject(pom);
        projectSession.setProjects(Arrays.asList(pom));
        projectSession.getRequest().setRecursive(false);
        projectSession.getRequest().setPom(pom.getFile());
        projectSession.getRequest().setGoals(Arrays.asList(goal));
        projectSession.getRequest().setInteractiveMode(false);
        this.lifecycleExecutor.execute(projectSession);
        if (projectSession.getResult().hasExceptions()) {
            throw new SonarException("Exception during execution of " + goal);
        }
    }

    public void concreteExecuteMaven2(Method executeMethod, MavenProject pom, String goal) {
        try {
            ReactorManager reactor = new ReactorManager(Arrays.asList(pom));
            MavenSession clonedSession = new MavenSession(this.mavenSession.getContainer(), this.mavenSession.getSettings(), this.mavenSession.getLocalRepository(), this.mavenSession.getEventDispatcher(), reactor, Arrays.asList(goal), this.mavenSession.getExecutionRootDirectory(), this.mavenSession.getExecutionProperties(), this.mavenSession.getStartTime());
            executeMethod.invoke((Object)this.lifecycleExecutor, clonedSession, reactor, clonedSession.getEventDispatcher());
        }
        catch (Exception e) {
            throw new SonarException("Unable to execute Maven 2 plugin", (Throwable)e);
        }
    }
}

