/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.mediumtest;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.sonar.api.SonarPlugin;
import org.sonar.api.batch.analyzer.issue.AnalyzerIssue;
import org.sonar.api.batch.analyzer.issue.internal.DefaultAnalyzerIssue;
import org.sonar.api.batch.analyzer.measure.AnalyzerMeasure;
import org.sonar.api.batch.analyzer.measure.internal.DefaultAnalyzerMeasure;
import org.sonar.api.batch.debt.internal.DefaultDebtModel;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.RulesBuilder;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleQuery;
import org.sonar.batch.bootstrap.PluginsReferential;
import org.sonar.batch.bootstrapper.Batch;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.languages.Language;
import org.sonar.batch.languages.LanguagesReferential;
import org.sonar.batch.rule.QProfile;
import org.sonar.batch.rules.QProfilesReferential;
import org.sonar.batch.scan2.AnalyzerIssueCache;
import org.sonar.batch.scan2.AnalyzerMeasureCache;
import org.sonar.batch.scan2.ProjectScanContainer;
import org.sonar.batch.scan2.ScanTaskObserver;
import org.sonar.batch.settings.SettingsReferential;
import org.sonar.core.plugins.DefaultPluginMetadata;
import org.sonar.core.plugins.RemotePlugin;

public class AnalyzerMediumTester {
    private Batch batch;

    public static AnalyzerMediumTesterBuilder builder() {
        return new AnalyzerMediumTesterBuilder().registerCoreMetrics();
    }

    public void start() {
        this.batch.start();
    }

    public void stop() {
        this.batch.stop();
    }

    private AnalyzerMediumTester(AnalyzerMediumTesterBuilder builder) {
        this.batch = Batch.builder().setEnableLoggingConfiguration(true).addComponents(new EnvironmentInformation("mediumTest", "1.0"), builder.settingsReferential, builder.pluginsReferential, builder.metricFinder, builder.ruleFinder, builder.qProfileReferential, builder.rulesBuilder.build(), builder.activeRulesBuilder.build(), new DefaultDebtModel(), builder.languageReferential).setBootstrapProperties(builder.bootstrapProperties).build();
    }

    public TaskBuilder newTask() {
        return new TaskBuilder(this);
    }

    public TaskBuilder newScanTask(File sonarProps) {
        Properties prop = new Properties();
        FileReader reader = null;
        try {
            reader = new FileReader(sonarProps);
            prop.load(reader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read configuration file", e);
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        TaskBuilder builder = new TaskBuilder(this);
        builder.property("sonar.task", "scan");
        builder.property("sonar.projectBaseDir", sonarProps.getParentFile().getAbsolutePath());
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            builder.property(entry.getKey().toString(), entry.getValue().toString());
        }
        return builder;
    }

    private static class FakeLanguageReferential
    implements LanguagesReferential {
        private Map<String, Language> languages = new HashMap<String, Language>();

        private FakeLanguageReferential() {
        }

        public FakeLanguageReferential register(org.sonar.api.resources.Language ... languages) {
            for (org.sonar.api.resources.Language language : languages) {
                this.languages.put(language.getKey(), new Language(language.getKey(), language.getName(), language.getFileSuffixes()));
            }
            return this;
        }

        @Override
        public Language get(String languageKey) {
            return this.languages.get(languageKey);
        }

        @Override
        public Collection<Language> all() {
            return this.languages.values();
        }
    }

    private static class FakeQProfileReferential
    implements QProfilesReferential {
        private Map<String, Map<String, QProfile>> profiles = new HashMap<String, Map<String, QProfile>>();

        private FakeQProfileReferential() {
        }

        @Override
        public QProfile get(String language, String name) {
            return this.profiles.get(language).get(name);
        }

        public void add(QProfile qprofile) {
            if (!this.profiles.containsKey(qprofile.getLanguage())) {
                this.profiles.put(qprofile.getLanguage(), new HashMap());
            }
            this.profiles.get(qprofile.getLanguage()).put(qprofile.getName(), qprofile);
        }
    }

    private static class FakeRuleFinder
    implements RuleFinder {
        private BiMap<Integer, Rule> rulesById = HashBiMap.create();
        private Map<String, Map<String, Rule>> rulesByRepoKeyAndRuleKey = Maps.newHashMap();

        private FakeRuleFinder() {
        }

        public Rule findById(int ruleId) {
            return (Rule)this.rulesById.get((Object)ruleId);
        }

        public Rule findByKey(String repositoryKey, String ruleKey) {
            Map<String, Rule> repository = this.rulesByRepoKeyAndRuleKey.get(repositoryKey);
            return repository != null ? repository.get(ruleKey) : null;
        }

        public Rule findByKey(RuleKey key) {
            return this.findByKey(key.repository(), key.rule());
        }

        public Rule find(RuleQuery query) {
            throw new UnsupportedOperationException();
        }

        public Collection<Rule> findAll(RuleQuery query) {
            throw new UnsupportedOperationException();
        }
    }

    private static class FakeMetricFinder
    implements MetricFinder {
        private Map<String, Metric> metricsByKey = Maps.newLinkedHashMap();
        private Map<Integer, Metric> metricsById = Maps.newLinkedHashMap();

        private FakeMetricFinder() {
        }

        public FakeMetricFinder add(int id, Metric metric) {
            this.metricsByKey.put(metric.getKey(), metric);
            this.metricsById.put(id, metric);
            return this;
        }

        public Metric findById(int metricId) {
            return this.metricsById.get(metricId);
        }

        public Metric findByKey(String key) {
            return this.metricsByKey.get(key);
        }

        public Collection<Metric> findAll(List<String> metricKeys) {
            LinkedList result = Lists.newLinkedList();
            for (String metricKey : metricKeys) {
                Metric metric = this.findByKey(metricKey);
                if (metric == null) continue;
                result.add(metric);
            }
            return result;
        }

        public Collection<Metric> findAll() {
            return this.metricsByKey.values();
        }
    }

    private static class FackPluginsReferential
    implements PluginsReferential {
        private List<RemotePlugin> pluginList = new ArrayList<RemotePlugin>();
        private Map<RemotePlugin, File> pluginFiles = new HashMap<RemotePlugin, File>();
        Map<PluginMetadata, SonarPlugin> localPlugins = new HashMap<PluginMetadata, SonarPlugin>();

        private FackPluginsReferential() {
        }

        @Override
        public List<RemotePlugin> pluginList() {
            return this.pluginList;
        }

        @Override
        public File pluginFile(RemotePlugin remote) {
            return this.pluginFiles.get(remote);
        }

        public FackPluginsReferential addPlugin(String pluginKey, File location) {
            RemotePlugin plugin = new RemotePlugin(pluginKey, false);
            this.pluginList.add(plugin);
            this.pluginFiles.put(plugin, location);
            return this;
        }

        public FackPluginsReferential addPlugin(String pluginKey, SonarPlugin pluginInstance) {
            this.localPlugins.put((PluginMetadata)DefaultPluginMetadata.create(null).setKey(pluginKey), pluginInstance);
            return this;
        }

        @Override
        public Map<PluginMetadata, SonarPlugin> localPlugins() {
            return this.localPlugins;
        }
    }

    private static class FakeSettingsReferential
    implements SettingsReferential {
        private Map<String, String> globalSettings = new HashMap<String, String>();
        private Map<String, Map<String, String>> projectSettings = new HashMap<String, Map<String, String>>();

        private FakeSettingsReferential() {
        }

        @Override
        public Map<String, String> globalSettings() {
            return this.globalSettings;
        }

        @Override
        public Map<String, String> projectSettings(String projectKey) {
            return this.projectSettings.containsKey(projectKey) ? this.projectSettings.get(projectKey) : Collections.emptyMap();
        }
    }

    public static class TaskResult
    implements ScanTaskObserver {
        private List<AnalyzerIssue> issues = new ArrayList<AnalyzerIssue>();
        private List<AnalyzerMeasure> measures = new ArrayList<AnalyzerMeasure>();

        @Override
        public void scanTaskCompleted(ProjectScanContainer container) {
            for (DefaultAnalyzerIssue issue : ((AnalyzerIssueCache)container.getComponentByType(AnalyzerIssueCache.class)).all()) {
                this.issues.add((AnalyzerIssue)issue);
            }
            for (DefaultAnalyzerMeasure measure : ((AnalyzerMeasureCache)container.getComponentByType(AnalyzerMeasureCache.class)).all()) {
                this.measures.add((AnalyzerMeasure)measure);
            }
        }

        public List<AnalyzerIssue> issues() {
            return this.issues;
        }

        public List<AnalyzerMeasure> measures() {
            return this.measures;
        }
    }

    public static class TaskBuilder {
        private final Map<String, String> taskProperties = new HashMap<String, String>();
        private AnalyzerMediumTester tester;

        public TaskBuilder(AnalyzerMediumTester tester) {
            this.tester = tester;
        }

        public TaskResult start() {
            TaskResult result = new TaskResult();
            this.tester.batch.executeTask(this.taskProperties, result);
            return result;
        }

        public TaskBuilder properties(Map<String, String> props) {
            this.taskProperties.putAll(props);
            return this;
        }

        public TaskBuilder property(String key, String value) {
            this.taskProperties.put(key, value);
            return this;
        }
    }

    public static class AnalyzerMediumTesterBuilder {
        private final FakeSettingsReferential settingsReferential = new FakeSettingsReferential();
        private final FackPluginsReferential pluginsReferential = new FackPluginsReferential();
        private final FakeMetricFinder metricFinder = new FakeMetricFinder();
        private final FakeRuleFinder ruleFinder = new FakeRuleFinder();
        private final FakeQProfileReferential qProfileReferential = new FakeQProfileReferential();
        private final FakeLanguageReferential languageReferential = new FakeLanguageReferential();
        private final Map<String, String> bootstrapProperties = new HashMap<String, String>();
        private final RulesBuilder rulesBuilder = new RulesBuilder();
        private final ActiveRulesBuilder activeRulesBuilder = new ActiveRulesBuilder();
        private int metricId = 1;

        public AnalyzerMediumTester build() {
            return new AnalyzerMediumTester(this);
        }

        public AnalyzerMediumTesterBuilder registerPlugin(String pluginKey, File location) {
            this.pluginsReferential.addPlugin(pluginKey, location);
            return this;
        }

        public AnalyzerMediumTesterBuilder registerPlugin(String pluginKey, SonarPlugin instance) {
            this.pluginsReferential.addPlugin(pluginKey, instance);
            return this;
        }

        public AnalyzerMediumTesterBuilder registerCoreMetrics() {
            for (Metric m : CoreMetrics.getMetrics()) {
                this.registerMetric(m);
            }
            return this;
        }

        public AnalyzerMediumTesterBuilder registerMetric(Metric<?> metric) {
            this.metricFinder.add(this.metricId, metric);
            ++this.metricId;
            return this;
        }

        public AnalyzerMediumTesterBuilder addQProfile(String language, String name) {
            this.qProfileReferential.add(new QProfile().setKey(name).setName(name).setLanguage(language).setRulesUpdatedAt(new Date()));
            return this;
        }

        public AnalyzerMediumTesterBuilder addDefaultQProfile(String language, String name) {
            this.addQProfile(language, name);
            this.settingsReferential.globalSettings().put("sonar.profile." + language, name);
            return this;
        }

        public AnalyzerMediumTesterBuilder registerLanguage(org.sonar.api.resources.Language ... languages) {
            this.languageReferential.register(languages);
            return this;
        }

        public AnalyzerMediumTesterBuilder bootstrapProperties(Map<String, String> props) {
            this.bootstrapProperties.putAll(props);
            return this;
        }

        public AnalyzerMediumTesterBuilder activateRule(RuleKey key) {
            this.rulesBuilder.add(key);
            this.activeRulesBuilder.create(key).activate();
            return this;
        }

        public AnalyzerMediumTesterBuilder registerInactiveRule(RuleKey key) {
            this.rulesBuilder.add(key);
            return this;
        }
    }
}

