/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.qualitygate;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.sonar.api.measures.Metric;
import org.sonar.batch.qualitygate.ResolvedCondition;

class QualityGateDetails {
    private static final String FIELD_LEVEL = "level";
    private Metric.Level level = Metric.Level.OK;
    private List<EvaluatedCondition> conditions = Lists.newArrayList();

    QualityGateDetails() {
    }

    void setLevel(Metric.Level level) {
        this.level = level;
    }

    void addCondition(ResolvedCondition condition, Metric.Level level, Double actualValue) {
        this.conditions.add(new EvaluatedCondition(condition, level, actualValue));
    }

    String toJson() {
        JsonObject details = new JsonObject();
        details.addProperty(FIELD_LEVEL, this.level.toString());
        JsonArray conditionResults = new JsonArray();
        for (EvaluatedCondition condition : this.conditions) {
            conditionResults.add((JsonElement)condition.toJson());
        }
        details.add("conditions", (JsonElement)conditionResults);
        return details.toString();
    }

    static class EvaluatedCondition {
        private ResolvedCondition condition;
        private Metric.Level level;
        private String actualValue;

        EvaluatedCondition(ResolvedCondition condition, Metric.Level level, Double actualValue) {
            this.condition = condition;
            this.level = level;
            this.actualValue = actualValue == null ? "" : actualValue.toString();
        }

        JsonObject toJson() {
            JsonObject result = new JsonObject();
            result.addProperty("metric", this.condition.metricKey());
            result.addProperty("op", this.condition.operator());
            if (this.condition.period() != null) {
                result.addProperty("period", (Number)this.condition.period());
            }
            if (this.condition.warningThreshold() != null) {
                result.addProperty("warning", this.condition.warningThreshold());
            }
            if (this.condition.errorThreshold() != null) {
                result.addProperty("error", this.condition.errorThreshold());
            }
            result.addProperty("actual", this.actualValue);
            result.addProperty(QualityGateDetails.FIELD_LEVEL, this.level.toString());
            return result;
        }
    }
}

