/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.qualitygate;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.picocontainer.injectors.ProviderAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.batch.qualitygate.QualityGate;
import org.sonar.batch.qualitygate.ResolvedCondition;

public class QualityGateProvider
extends ProviderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(QualityGateProvider.class);
    private static final String PROPERTY_QUALITY_GATE = "sonar.qualitygate";
    private static final String SHOW_URL = "/api/qualitygates/show";
    private static final String ATTRIBUTE_CONDITIONS = "conditions";
    private QualityGate instance;

    public QualityGate provide(Settings settings, ServerClient client, MetricFinder metricFinder) {
        if (this.instance == null) {
            this.instance = this.init(settings, client, metricFinder, LOG);
        }
        return this.instance;
    }

    @VisibleForTesting
    QualityGate init(Settings settings, ServerClient client, MetricFinder metricFinder, Logger logger) {
        QualityGate result = QualityGate.disabled();
        String qualityGateSetting = settings.getString(PROPERTY_QUALITY_GATE);
        if (qualityGateSetting == null) {
            logger.info("No quality gate is configured.");
        } else {
            result = this.load(qualityGateSetting, client, metricFinder);
            logger.info("Loaded quality gate '{}'", (Object)result.name());
        }
        return result;
    }

    private QualityGate load(String qualityGateSetting, ServerClient client, MetricFinder metricFinder) {
        QualityGate configuredGate = null;
        try {
            configuredGate = this.fetch(qualityGateSetting, client, metricFinder);
        }
        catch (HttpDownloader.HttpException serverError) {
            if (serverError.getResponseCode() == 404) {
                throw MessageException.of((String)("Quality gate '" + qualityGateSetting + "' was not found."));
            }
            throw serverError;
        }
        return configuredGate;
    }

    private QualityGate fetch(String qualityGateSetting, ServerClient client, MetricFinder metricFinder) {
        String jsonText = null;
        try {
            long qGateId = Long.valueOf(qualityGateSetting);
            jsonText = client.request("/api/qualitygates/show?id=" + qGateId, false);
        }
        catch (NumberFormatException configIsNameInsteadOfId) {
            jsonText = client.request("/api/qualitygates/show?name=" + qualityGateSetting, false);
        }
        JsonParser parser = new JsonParser();
        JsonObject root = parser.parse(jsonText).getAsJsonObject();
        QualityGate configuredGate = new QualityGate(root.get("name").getAsString());
        if (root.has(ATTRIBUTE_CONDITIONS)) {
            for (JsonElement condition : root.get(ATTRIBUTE_CONDITIONS).getAsJsonArray()) {
                JsonObject conditionObject = condition.getAsJsonObject();
                configuredGate.add(new ResolvedCondition(conditionObject, metricFinder.findByKey(conditionObject.get("metric").getAsString())));
            }
        }
        return configuredGate;
    }
}

