/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.qualitygate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.i18n.I18n;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Durations;
import org.sonar.batch.qualitygate.ConditionUtils;
import org.sonar.batch.qualitygate.QualityGate;
import org.sonar.batch.qualitygate.QualityGateDetails;
import org.sonar.batch.qualitygate.ResolvedCondition;
import org.sonar.core.timemachine.Periods;

public class QualityGateVerifier
implements Decorator {
    private static final String VARIATION_METRIC_PREFIX = "new_";
    private static final String VARIATION = "variation";
    private static final Map<String, String> OPERATOR_LABELS = ImmutableMap.of((Object)"EQ", (Object)"=", (Object)"NE", (Object)"!=", (Object)"GT", (Object)">", (Object)"LT", (Object)"<");
    private QualityGate qualityGate;
    private Snapshot snapshot;
    private Periods periods;
    private I18n i18n;
    private Durations durations;

    public QualityGateVerifier(QualityGate qualityGate, Snapshot snapshot, Periods periods, I18n i18n, Durations durations) {
        this.qualityGate = qualityGate;
        this.snapshot = snapshot;
        this.periods = periods;
        this.i18n = i18n;
        this.durations = durations;
    }

    @DependedUpon
    public Metric generatesQualityGateStatus() {
        return CoreMetrics.ALERT_STATUS;
    }

    @DependsUpon
    public String dependsOnVariations() {
        return "END_OF_TIME_MACHINE";
    }

    @DependsUpon
    public Collection<Metric> dependsUponMetrics() {
        HashSet metrics = Sets.newHashSet();
        for (ResolvedCondition condition : this.qualityGate.conditions()) {
            metrics.add(condition.metric());
        }
        return metrics;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.qualityGate.isEnabled();
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (ResourceUtils.isRootProject((Resource)resource)) {
            this.checkProjectConditions(resource, context);
        }
    }

    private void checkProjectConditions(Resource resource, DecoratorContext context) {
        Metric.Level globalLevel = Metric.Level.OK;
        QualityGateDetails details = new QualityGateDetails();
        ArrayList labels = Lists.newArrayList();
        for (ResolvedCondition condition : this.qualityGate.conditions()) {
            Measure measure = context.getMeasure(condition.metric());
            if (measure == null) continue;
            Metric.Level level = ConditionUtils.getLevel(condition, measure);
            measure.setAlertStatus(level);
            String text = this.getText(condition, level);
            if (!StringUtils.isBlank((String)text)) {
                measure.setAlertText(text);
                labels.add(text);
            }
            context.saveMeasure(measure);
            if (Metric.Level.WARN == level && globalLevel != Metric.Level.ERROR) {
                globalLevel = Metric.Level.WARN;
            } else if (Metric.Level.ERROR == level) {
                globalLevel = Metric.Level.ERROR;
            }
            details.addCondition(condition, level, ConditionUtils.getValue(condition, measure));
        }
        Measure globalMeasure = new Measure(CoreMetrics.ALERT_STATUS, globalLevel);
        globalMeasure.setAlertStatus(globalLevel);
        globalMeasure.setAlertText(StringUtils.join((Collection)labels, (String)", "));
        context.saveMeasure(globalMeasure);
        details.setLevel(globalLevel);
        Measure detailsMeasure = new Measure(CoreMetrics.QUALITY_GATE_DETAILS, details.toJson());
        context.saveMeasure(detailsMeasure);
    }

    private String getText(ResolvedCondition condition, Metric.Level level) {
        if (level == Metric.Level.OK) {
            return null;
        }
        return this.getAlertLabel(condition, level);
    }

    private String getAlertLabel(ResolvedCondition condition, Metric.Level level) {
        Integer alertPeriod = condition.period();
        String metric = this.i18n.message(Locale.ENGLISH, "metric." + condition.metricKey() + ".name", condition.metric().getName(), new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(metric);
        if (alertPeriod != null && !condition.metricKey().startsWith(VARIATION_METRIC_PREFIX)) {
            String variation = this.i18n.message(Locale.ENGLISH, VARIATION, VARIATION, new Object[0]).toLowerCase();
            stringBuilder.append(" ").append(variation);
        }
        stringBuilder.append(" ").append(this.operatorLabel(condition.operator())).append(" ").append(this.alertValue(condition, level));
        if (alertPeriod != null) {
            stringBuilder.append(" ").append(this.periods.label(this.snapshot, alertPeriod.intValue()));
        }
        return stringBuilder.toString();
    }

    private String alertValue(ResolvedCondition condition, Metric.Level level) {
        String value;
        String string = value = level.equals((Object)Metric.Level.ERROR) ? condition.errorThreshold() : condition.warningThreshold();
        if (condition.metric().getType().equals((Object)Metric.ValueType.WORK_DUR)) {
            return this.formatDuration(value);
        }
        return value;
    }

    private String formatDuration(String value) {
        return this.durations.format(Locale.ENGLISH, Duration.create((long)Long.parseLong(value)), Durations.DurationFormat.SHORT);
    }

    private String operatorLabel(String operator) {
        return OPERATOR_LABELS.get(operator);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

