/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.rule;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.batch.rule.QProfile;
import org.sonar.core.UtcDateUtils;

@Immutable
public class UsedQProfiles {
    private final SortedSet<QProfile> profiles = Sets.newTreeSet((Comparator)new Comparator<QProfile>(){

        @Override
        public int compare(QProfile o1, QProfile o2) {
            int c = o1.getLanguage().compareTo(o2.getLanguage());
            if (c == 0) {
                c = o1.getName().compareTo(o2.getName());
            }
            return c;
        }
    });

    public static UsedQProfiles fromJson(String json) {
        UsedQProfiles result = new UsedQProfiles();
        JsonArray jsonRoot = new JsonParser().parse(json).getAsJsonArray();
        for (JsonElement jsonElt : jsonRoot) {
            JsonObject jsonProfile = jsonElt.getAsJsonObject();
            QProfile profile = new QProfile();
            profile.setKey(jsonProfile.get("key").getAsString());
            profile.setName(jsonProfile.get("name").getAsString());
            profile.setLanguage(jsonProfile.get("language").getAsString());
            profile.setRulesUpdatedAt(UtcDateUtils.parseDateTime((String)jsonProfile.get("rulesUpdatedAt").getAsString()));
            result.add(profile);
        }
        return result;
    }

    public String toJson() {
        StringWriter json = new StringWriter();
        JsonWriter writer = JsonWriter.of((Writer)json);
        writer.beginArray();
        for (QProfile profile : this.profiles) {
            writer.beginObject().prop("key", profile.getKey()).prop("language", profile.getLanguage()).prop("name", profile.getName()).prop("rulesUpdatedAt", UtcDateUtils.formatDateTime((Date)profile.getRulesUpdatedAt())).endObject();
        }
        writer.endArray();
        writer.close();
        return json.toString();
    }

    public UsedQProfiles add(UsedQProfiles other) {
        this.addAll(other.profiles);
        return this;
    }

    public UsedQProfiles add(QProfile profile) {
        this.profiles.add(profile);
        return this;
    }

    public UsedQProfiles addAll(Collection<QProfile> profiles) {
        this.profiles.addAll(profiles);
        return this;
    }

    public SortedSet<QProfile> profiles() {
        return this.profiles;
    }

    public Map<String, QProfile> profilesByKey() {
        HashMap<String, QProfile> map = new HashMap<String, QProfile>();
        for (QProfile profile : this.profiles) {
            map.put(profile.getKey(), profile);
        }
        return map;
    }
}

