/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import org.picocontainer.Startable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.languages.Language;
import org.sonar.batch.languages.LanguagesReferential;

public class LanguageVerifier
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageVerifier.class);
    private final Settings settings;
    private final LanguagesReferential languages;
    private final DefaultFileSystem fs;

    public LanguageVerifier(Settings settings, LanguagesReferential languages, DefaultFileSystem fs) {
        this.settings = settings;
        this.languages = languages;
        this.fs = fs;
    }

    public void start() {
        if (this.settings.hasKey("sonar.language")) {
            String languageKey = this.settings.getString("sonar.language");
            LOG.info("Language is forced to {}", (Object)languageKey);
            Language language = this.languages.get(languageKey);
            if (language == null) {
                throw MessageException.of((String)("You must install a plugin that supports the language '" + languageKey + "'"));
            }
            this.fs.addLanguages(languageKey, new String[0]);
        }
    }

    public void stop() {
    }
}

