/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import javax.persistence.Query;
import org.sonar.api.BatchComponent;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.database.model.SnapshotSource;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.ServerClient;

public class LastSnapshots
implements BatchComponent {
    private final AnalysisMode analysisMode;
    private final DatabaseSession session;
    private final ServerClient server;

    public LastSnapshots(AnalysisMode analysisMode, DatabaseSession session, ServerClient server) {
        this.analysisMode = analysisMode;
        this.session = session;
        this.server = server;
    }

    public String getSource(Resource resource) {
        String source = "";
        if (ResourceUtils.isFile((Resource)resource)) {
            source = this.analysisMode.isPreview() ? this.loadSourceFromWs(resource) : this.loadSourceFromDb(resource);
        }
        return source;
    }

    private String loadSourceFromWs(Resource resource) {
        try {
            return this.server.request("/api/sources?resource=" + resource.getEffectiveKey() + "&format=txt", false, this.analysisMode.getPreviewReadTimeoutSec() * 1000);
        }
        catch (HttpDownloader.HttpException he) {
            if (he.getResponseCode() == 404) {
                return "";
            }
            throw he;
        }
    }

    private String loadSourceFromDb(Resource resource) {
        SnapshotSource source;
        Snapshot snapshot = this.getSnapshot(resource);
        if (snapshot != null && (source = (SnapshotSource)this.session.getSingleResult(SnapshotSource.class, new Object[]{"snapshotId", snapshot.getId()})) != null) {
            return source.getData();
        }
        return "";
    }

    private Snapshot getSnapshot(Resource resource) {
        Query query = this.session.createQuery("from " + Snapshot.class.getSimpleName() + " s where s.last=:last and s.resourceId=(select r.id from " + ResourceModel.class.getSimpleName() + " r where r.key=:key)");
        query.setParameter("key", (Object)resource.getEffectiveKey());
        query.setParameter("last", (Object)Boolean.TRUE);
        return (Snapshot)this.session.getSingleResult(query, null);
    }
}

