/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.FileExclusions;
import org.sonar.batch.DefaultProjectClasspath;
import org.sonar.batch.DefaultSensorContext;
import org.sonar.batch.DefaultTimeMachine;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.bootstrap.BatchExtensionDictionnary;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.ExtensionMatcher;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.components.TimeMachineConfiguration;
import org.sonar.batch.debt.DebtDecorator;
import org.sonar.batch.debt.IssueChangelogDebtCalculator;
import org.sonar.batch.debt.NewDebtDecorator;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.ResourcePersister;
import org.sonar.batch.issue.IssuableFactory;
import org.sonar.batch.issue.IssueFilters;
import org.sonar.batch.issue.ModuleIssues;
import org.sonar.batch.issue.ignore.EnforceIssuesFilter;
import org.sonar.batch.issue.ignore.IgnoreIssuesFilter;
import org.sonar.batch.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonar.batch.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonar.batch.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.batch.issue.ignore.scanner.IssueExclusionsRegexpScanner;
import org.sonar.batch.language.LanguageDistributionDecorator;
import org.sonar.batch.phases.PhaseExecutor;
import org.sonar.batch.phases.PhasesTimeProfiler;
import org.sonar.batch.qualitygate.GenerateQualityGateEvents;
import org.sonar.batch.qualitygate.QualityGateProvider;
import org.sonar.batch.qualitygate.QualityGateVerifier;
import org.sonar.batch.rule.ActiveRulesProvider;
import org.sonar.batch.rule.ModuleQProfiles;
import org.sonar.batch.rule.QProfileDecorator;
import org.sonar.batch.rule.QProfileEventsDecorator;
import org.sonar.batch.rule.QProfileSensor;
import org.sonar.batch.rule.QProfileVerifier;
import org.sonar.batch.rule.RulesProfileProvider;
import org.sonar.batch.scan.AnalyzerContextAdaptor;
import org.sonar.batch.scan.LanguageVerifier;
import org.sonar.batch.scan.ModuleSettings;
import org.sonar.batch.scan.ProjectScanContainer;
import org.sonar.batch.scan.filesystem.ComponentIndexer;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.DeprecatedFileFilters;
import org.sonar.batch.scan.filesystem.ExclusionFilters;
import org.sonar.batch.scan.filesystem.FileIndexer;
import org.sonar.batch.scan.filesystem.FileSystemLogger;
import org.sonar.batch.scan.filesystem.InputFileBuilderFactory;
import org.sonar.batch.scan.filesystem.LanguageDetectionFactory;
import org.sonar.batch.scan.filesystem.ModuleFileSystemInitializer;
import org.sonar.batch.scan.filesystem.ModuleInputFileCache;
import org.sonar.batch.scan.filesystem.PreviousFileHashLoader;
import org.sonar.batch.scan.filesystem.ProjectFileSystemAdapter;
import org.sonar.batch.scan.filesystem.StatusDetectionFactory;
import org.sonar.batch.scan.report.JsonReport;
import org.sonar.batch.scan2.AnalyzerOptimizer;
import org.sonar.core.component.ScanPerspectives;
import org.sonar.core.measure.MeasurementFilters;

public class ModuleScanContainer
extends ComponentContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleScanContainer.class);
    private final Project module;

    public ModuleScanContainer(ProjectScanContainer parent, Project module) {
        super((ComponentContainer)parent);
        this.module = module;
    }

    protected void doBeforeStart() {
        LOG.info("-------------  Scan {}", (Object)this.module.getName());
        this.addCoreComponents();
        this.addExtensions();
    }

    private void addCoreComponents() {
        ProjectDefinition moduleDefinition = ((ProjectTree)this.getComponentByType(ProjectTree.class)).getProjectDefinition(this.module);
        this.add(new Object[]{moduleDefinition, this.module.getConfiguration(), this.module, ModuleSettings.class});
        this.getComponentByType(ModuleSettings.class);
        this.add(new Object[]{EventBus.class, PhaseExecutor.class, PhasesTimeProfiler.class, PhaseExecutor.getPhaseClasses(), moduleDefinition.getContainerExtensions(), ModuleInputFileCache.class, FileExclusions.class, ExclusionFilters.class, DeprecatedFileFilters.class, InputFileBuilderFactory.class, StatusDetectionFactory.class, LanguageDetectionFactory.class, PreviousFileHashLoader.class, FileIndexer.class, ComponentIndexer.class, LanguageVerifier.class, FileSystemLogger.class, DefaultProjectClasspath.class, DefaultModuleFileSystem.class, ModuleFileSystemInitializer.class, ProjectFileSystemAdapter.class, QProfileVerifier.class, AnalyzerOptimizer.class, ((ResourcePersister)this.getComponentByType(ResourcePersister.class)).getSnapshot((Resource)this.module), TimeMachineConfiguration.class, DefaultSensorContext.class, AnalyzerContextAdaptor.class, BatchExtensionDictionnary.class, DefaultTimeMachine.class, ViolationFilters.class, IssueFilters.class, MeasurementFilters.class, ResourceFilters.class, new QualityGateProvider(), QualityGateVerifier.class, GenerateQualityGateEvents.class, ModuleQProfiles.class, new ActiveRulesProvider(), new RulesProfileProvider(), QProfileSensor.class, QProfileDecorator.class, QProfileEventsDecorator.class, CheckFactory.class, JsonReport.class, IssuableFactory.class, ModuleIssues.class, IssueInclusionPatternInitializer.class, IssueExclusionPatternInitializer.class, IssueExclusionsRegexpScanner.class, IssueExclusionsLoader.class, EnforceIssuesFilter.class, IgnoreIssuesFilter.class, LanguageDistributionDecorator.class, IssueChangelogDebtCalculator.class, DebtDecorator.class, NewDebtDecorator.class, ScanPerspectives.class});
    }

    private void addExtensions() {
        ExtensionInstaller installer = (ExtensionInstaller)this.getComponentByType(ExtensionInstaller.class);
        installer.install(this, new ExtensionMatcher(){

            @Override
            public boolean accept(Object extension) {
                if (ExtensionUtils.isType(extension, BatchComponent.class) && ExtensionUtils.isInstantiationStrategy(extension, "PER_PROJECT")) {
                    return !ExtensionUtils.isMavenExtensionOnly(extension) || ModuleScanContainer.this.module.getPom() != null;
                }
                return false;
            }
        });
    }

    protected void doAfterStart() {
        DefaultIndex index = (DefaultIndex)((Object)this.getComponentByType(DefaultIndex.class));
        index.setCurrentProject(this.module, (ModuleIssues)this.getComponentByType(ModuleIssues.class));
        ((PhaseExecutor)this.getComponentByType(PhaseExecutor.class)).execute(this.module);
    }
}

