/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.i18n.I18n;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.Semaphores;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.bootstrap.AnalysisMode;

public class ProjectLock {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectLock.class);
    private final Semaphores semaphores;
    private final ProjectTree projectTree;
    private final AnalysisMode analysisMode;
    private final I18n i18n;

    public ProjectLock(Semaphores semaphores, ProjectTree projectTree, AnalysisMode analysisMode, I18n i18n) {
        this.semaphores = semaphores;
        this.projectTree = projectTree;
        this.analysisMode = analysisMode;
        this.i18n = i18n;
    }

    public void start() {
        Semaphores.Semaphore semaphore;
        if (!this.analysisMode.isPreview() && StringUtils.isNotBlank((String)this.getProject().getKey()) && !(semaphore = this.acquire()).isLocked()) {
            LOG.error(this.getErrorMessage(semaphore));
            throw new SonarException("The project is already being analysed.");
        }
    }

    private String getErrorMessage(Semaphores.Semaphore semaphore) {
        long duration = semaphore.getDurationSinceLocked();
        String durationDisplay = this.i18n.age(Locale.ENGLISH, duration);
        return "It looks like an analysis of '" + this.getProject().getName() + "' is already running (started " + durationDisplay + " ago).";
    }

    public void stop() {
        if (!this.analysisMode.isPreview()) {
            this.release();
        }
    }

    private Semaphores.Semaphore acquire() {
        LOG.debug("Acquire semaphore on project : {}, with key {}", (Object)this.getProject(), (Object)this.getSemaphoreKey());
        return this.semaphores.acquire(this.getSemaphoreKey(), 15, 10);
    }

    private void release() {
        LOG.debug("Release semaphore on project : {}, with key {}", (Object)this.getProject(), (Object)this.getSemaphoreKey());
        this.semaphores.release(this.getSemaphoreKey());
    }

    private String getSemaphoreKey() {
        return "batch-" + this.getProject().getKey();
    }

    private Project getProject() {
        return this.projectTree.getRootProject();
    }
}

