/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import java.io.File;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;
import org.sonar.api.scan.filesystem.FileSystemFilter;
import org.sonar.api.scan.filesystem.FileType;
import org.sonar.api.scan.filesystem.ModuleFileSystem;

public class DeprecatedFileFilters
implements InputFileFilter {
    private final FileSystemFilter[] filters;

    public DeprecatedFileFilters(FileSystemFilter[] filters) {
        this.filters = filters;
    }

    public DeprecatedFileFilters() {
        this(new FileSystemFilter[0]);
    }

    public boolean accept(InputFile inputFile) {
        if (this.filters.length > 0) {
            DeprecatedContext context = new DeprecatedContext(inputFile);
            for (FileSystemFilter filter : this.filters) {
                if (filter.accept(inputFile.file(), (FileSystemFilter.Context)context)) continue;
                return false;
            }
        }
        return true;
    }

    static class DeprecatedContext
    implements FileSystemFilter.Context {
        private final InputFile inputFile;

        DeprecatedContext(InputFile inputFile) {
            this.inputFile = inputFile;
        }

        public ModuleFileSystem fileSystem() {
            throw new UnsupportedOperationException("Not supported since 4.0");
        }

        public FileType type() {
            String type = this.inputFile.type().name();
            return FileType.valueOf((String)type);
        }

        public File relativeDir() {
            return new File(((DeprecatedDefaultInputFile)this.inputFile).sourceDirAbsolutePath());
        }

        public String relativePath() {
            return ((DeprecatedDefaultInputFile)this.inputFile).pathRelativeToSourceDir();
        }

        public String canonicalPath() {
            return this.inputFile.absolutePath();
        }
    }
}

