/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.RelativePathPredicate;
import org.sonar.api.resources.Project;
import org.sonar.batch.scan.filesystem.InputFileCache;

public class ModuleInputFileCache
extends DefaultFileSystem.Cache
implements BatchComponent {
    private final String moduleKey;
    private final InputFileCache projectCache;

    public ModuleInputFileCache(Project module, ProjectDefinition projectDef, InputFileCache projectCache) {
        this.moduleKey = module.getKey();
        this.projectCache = projectCache;
    }

    public ModuleInputFileCache(ProjectDefinition projectDef, InputFileCache projectCache) {
        this.moduleKey = projectDef.getKey();
        this.projectCache = projectCache;
    }

    protected Iterable<InputFile> inputFiles() {
        return this.projectCache.byModule(this.moduleKey);
    }

    protected InputFile inputFile(RelativePathPredicate predicate) {
        return this.projectCache.get(this.moduleKey, predicate.path());
    }

    protected void doAdd(InputFile inputFile) {
        this.projectCache.put(this.moduleKey, inputFile);
    }
}

