/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import org.sonar.api.BatchComponent;
import org.sonar.api.batch.analyzer.issue.internal.DefaultAnalyzerIssue;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.Caches;

public class AnalyzerIssueCache
implements BatchComponent {
    private final Cache<DefaultAnalyzerIssue> cache;

    public AnalyzerIssueCache(Caches caches) {
        this.cache = caches.createCache("issues");
    }

    public Iterable<DefaultAnalyzerIssue> byComponent(String projectKey, String resourceKey) {
        return this.cache.values(projectKey, resourceKey);
    }

    public Iterable<DefaultAnalyzerIssue> all() {
        return this.cache.values();
    }

    public AnalyzerIssueCache put(String projectKey, String resourceKey, DefaultAnalyzerIssue issue) {
        this.cache.put(projectKey, resourceKey, issue.key(), issue);
        return this;
    }

    public Iterable<DefaultAnalyzerIssue> byModule(String projectKey) {
        return this.cache.values(projectKey);
    }
}

