/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import org.sonar.api.BatchComponent;
import org.sonar.api.batch.analyzer.internal.DefaultAnalyzerDescriptor;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRules;

public class AnalyzerOptimizer
implements BatchComponent {
    private final FileSystem fs;
    private final ActiveRules activeRules;

    public AnalyzerOptimizer(FileSystem fs, ActiveRules activeRules) {
        this.fs = fs;
        this.activeRules = activeRules;
    }

    public boolean shouldExecute(DefaultAnalyzerDescriptor descriptor) {
        boolean fsCondition = this.fsCondition(descriptor);
        boolean activeRulesCondition = this.activeRulesCondition(descriptor);
        return fsCondition && activeRulesCondition;
    }

    private boolean activeRulesCondition(DefaultAnalyzerDescriptor descriptor) {
        if (!descriptor.ruleRepositories().isEmpty()) {
            for (String repoKey : descriptor.ruleRepositories()) {
                if (this.activeRules.findByRepository(repoKey).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean fsCondition(DefaultAnalyzerDescriptor descriptor) {
        if (!descriptor.languages().isEmpty() || !descriptor.types().isEmpty()) {
            FilePredicate langPredicate = descriptor.languages().isEmpty() ? this.fs.predicates().all() : this.fs.predicates().hasLanguages(descriptor.languages());
            FilePredicate typePredicate = descriptor.types().isEmpty() ? this.fs.predicates().all() : this.fs.predicates().none();
            for (InputFile.Type type : descriptor.types()) {
                typePredicate = this.fs.predicates().or(typePredicate, this.fs.predicates().hasType(type));
            }
            return this.fs.hasFiles(this.fs.predicates().and(langPredicate, typePredicate));
        }
        return true;
    }
}

