/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.settings;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.batch.settings.SettingsReferential;

public class DefaultSettingsReferential
implements SettingsReferential {
    private static final String BATCH_BOOTSTRAP_PROPERTIES_URL = "/batch_bootstrap/properties";
    private final ServerClient serverClient;
    private final AnalysisMode analysisMode;

    public DefaultSettingsReferential(ServerClient serverClient, AnalysisMode analysisMode) {
        this.serverClient = serverClient;
        this.analysisMode = analysisMode;
    }

    @Override
    public Map<String, String> globalSettings() {
        return this.downloadSettings(null);
    }

    @Override
    public Map<String, String> projectSettings(String moduleKey) {
        return this.downloadSettings(moduleKey);
    }

    private Map<String, String> downloadSettings(@Nullable String moduleKey) {
        HashMap result = Maps.newHashMap();
        String url = "/batch_bootstrap/properties?dryRun=" + this.analysisMode.isPreview();
        if (moduleKey != null) {
            url = url + "&project=" + moduleKey;
        }
        String jsonText = this.serverClient.request(url);
        List json = (List)new Gson().fromJson(jsonText, new TypeToken<List<Map<String, String>>>(){}.getType());
        for (Map jsonProperty : json) {
            String key = (String)jsonProperty.get("k");
            String value = (String)jsonProperty.get("v");
            result.put(key, value);
        }
        return result;
    }
}

