/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.source;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;
import org.sonar.batch.source.SyntaxHighlightingData;
import org.sonar.batch.source.SyntaxHighlightingRule;

public class SyntaxHighlightingDataBuilder {
    private List<SyntaxHighlightingRule> syntaxHighlightingRuleSet = Lists.newArrayList();

    public SyntaxHighlightingDataBuilder registerHighlightingRule(int startOffset, int endOffset, String typeOfText) {
        if (this.ruleConflictsWithExistingRules(startOffset, endOffset)) {
            String errorMsg = String.format("Cannot register highlighting rule for characters from %s to %s as it overlaps at least one existing rule", startOffset, endOffset);
            LoggerFactory.getLogger(SyntaxHighlightingDataBuilder.class).error(errorMsg);
            throw new UnsupportedOperationException(errorMsg);
        }
        SyntaxHighlightingRule syntaxHighlightingRule = SyntaxHighlightingRule.create(startOffset, endOffset, typeOfText);
        this.syntaxHighlightingRuleSet.add(syntaxHighlightingRule);
        return this;
    }

    public SyntaxHighlightingData build() {
        return new SyntaxHighlightingData(this.getSortedRules());
    }

    private boolean ruleConflictsWithExistingRules(final int startOffset, final int endOffset) {
        Collection conflictingRules = Collections2.filter(this.syntaxHighlightingRuleSet, (Predicate)new Predicate<SyntaxHighlightingRule>(){

            public boolean apply(@Nullable SyntaxHighlightingRule syntaxHighlightingRule) {
                if (syntaxHighlightingRule != null) {
                    boolean overlapsStartBoundary = startOffset < syntaxHighlightingRule.getStartPosition() && endOffset >= syntaxHighlightingRule.getStartPosition() + 1 && endOffset < syntaxHighlightingRule.getEndPosition();
                    boolean overlapsEndBoundary = startOffset > syntaxHighlightingRule.getStartPosition() && startOffset < syntaxHighlightingRule.getEndPosition() && endOffset > syntaxHighlightingRule.getEndPosition();
                    return overlapsStartBoundary || overlapsEndBoundary;
                }
                return false;
            }
        });
        return !conflictingRules.isEmpty();
    }

    @VisibleForTesting
    protected List<SyntaxHighlightingRule> getSortedRules() {
        Ordering<SyntaxHighlightingRule> ruleOrdering = new Ordering<SyntaxHighlightingRule>(){

            public int compare(@Nullable SyntaxHighlightingRule left, @Nullable SyntaxHighlightingRule right) {
                if (left != null && right != null) {
                    int result = left.getStartPosition() - right.getStartPosition();
                    if (result == 0) {
                        result = left.getEndPosition() - right.getEndPosition();
                    }
                    return result;
                }
                return left != null ? 1 : -1;
            }
        };
        return ruleOrdering.immutableSortedCopy(this.syntaxHighlightingRuleSet);
    }
}

