/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.dev;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class TrimMojo
extends AbstractMojo {
    private File directory;
    private String[] includes;
    private String[] excludes;
    private String sourceEncoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldExecute()) {
            this.trimDirectory();
        }
    }

    private void trimDirectory() throws MojoExecutionException {
        File[] files;
        for (File file : files = this.scanFiles()) {
            StringBuilder sb = new StringBuilder();
            try {
                LineIterator lines = FileUtils.lineIterator((File)file, (String)this.sourceEncoding);
                while (lines.hasNext()) {
                    String line = lines.nextLine();
                    if (!StringUtils.isNotBlank((String)line)) continue;
                    sb.append(StringUtils.trim((String)line));
                    sb.append(IOUtils.LINE_SEPARATOR);
                }
                FileUtils.writeStringToFile((File)file, (String)sb.toString(), (String)this.sourceEncoding);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can not trim the file " + file, (Exception)e);
            }
        }
        this.getLog().info((CharSequence)("Trimmed files: " + files.length));
    }

    private boolean shouldExecute() {
        return this.directory != null && this.directory.exists();
    }

    private File[] scanFiles() {
        String[] defaultIncludes = new String[]{"**\\*"};
        DirectoryScanner ds = new DirectoryScanner();
        if (this.includes == null) {
            ds.setIncludes(defaultIncludes);
        } else {
            ds.setIncludes(this.includes);
        }
        ds.addDefaultExcludes();
        if (this.excludes != null) {
            ds.setExcludes(this.excludes);
        }
        ds.setBasedir(this.directory);
        this.getLog().info((CharSequence)("Scanning directory " + this.directory));
        ds.scan();
        int maxFiles = ds.getIncludedFiles().length;
        File[] result = new File[maxFiles];
        for (int i = 0; i < maxFiles; ++i) {
            result[i] = new File(this.directory, ds.getIncludedFiles()[i]);
        }
        return result;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }
}

