/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.descriptor;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.Multiplicity;
import org.crsh.cli.impl.ParameterType;
import org.crsh.cli.impl.SyntaxException;
import org.crsh.cli.impl.descriptor.IllegalParameterException;
import org.crsh.cli.impl.descriptor.IllegalValueTypeException;
import org.crsh.cli.spi.Completer;

public class ArgumentDescriptor
extends ParameterDescriptor {
    private final String name;

    public ArgumentDescriptor(String name, ParameterType<?> type, Description info, boolean required, boolean password, boolean unquote, Class<? extends Completer> completerType, Annotation annotation) throws IllegalValueTypeException, IllegalParameterException {
        super(type, info, required, password, unquote, completerType, annotation);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object parse(List<String> values) throws SyntaxException {
        if (this.getMultiplicity() == Multiplicity.SINGLE) {
            if (values.size() > 1) {
                throw new SyntaxException("Too many option values " + values);
            }
            String value = values.get(0);
            try {
                return this.parse(value);
            }
            catch (Exception e) {
                throw new SyntaxException("Could not parse " + value);
            }
        }
        ArrayList<Object> v = new ArrayList<Object>(values.size());
        for (String value : values) {
            try {
                v.add(this.parse(value));
            }
            catch (Exception e) {
                throw new SyntaxException("Could not parse " + value);
            }
        }
        return v;
    }

    @Override
    public void printUsage(Appendable writer) throws IOException {
        writer.append('<');
        writer.append(this.name == null || this.name.length() == 0 ? "arg" : this.name);
        writer.append('>');
        if (this.getMultiplicity() == Multiplicity.MULTI) {
            writer.append("... ");
        }
    }

    public String toString() {
        return "ArgumentDescriptor[" + this.name + "]";
    }
}

