/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HBaseManagedConnection
extends AbstractManagedConnection {
    private Configuration config;
    private Map<String, HTable> tables;
    private int referenceCount = 0;
    private int idleTimeoutMills = 30000;
    private long expirationTime;
    private boolean isDisposed = false;

    public HBaseManagedConnection(Configuration config) {
        this.config = config;
        this.tables = new HashMap<String, HTable>();
        this.disableExpirationTime();
    }

    public Object getConnection() {
        throw new NucleusDataStoreException("Unsupported Exception #getConnection() for " + ((Object)((Object)this)).getClass().getName());
    }

    public HTable getHTable(String tableName) {
        HTable table = this.tables.get(tableName);
        if (table == null) {
            try {
                table = new HTable(this.config, tableName);
                this.tables.put(tableName, table);
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        return table;
    }

    public XAResource getXAResource() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        int i;
        if (this.tables.size() == 0) {
            return;
        }
        for (i = 0; i < this.listeners.size(); ++i) {
            ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
        }
        for (i = 0; i < this.listeners.size(); ++i) {
            ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
        }
    }

    void incrementReferenceCount() {
        ++this.referenceCount;
        this.disableExpirationTime();
    }

    public void release() {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            this.close();
            this.enableExpirationTime();
        } else if (this.referenceCount < 0) {
            throw new NucleusDataStoreException("Too many calls on release(): " + (Object)((Object)this));
        }
    }

    private void enableExpirationTime() {
        this.expirationTime = System.currentTimeMillis() + (long)this.idleTimeoutMills;
    }

    private void disableExpirationTime() {
        this.expirationTime = -1L;
    }

    public void setIdleTimeoutMills(int mills) {
        this.idleTimeoutMills = mills;
    }

    public boolean isExpired() {
        return this.expirationTime > 0L && this.expirationTime > System.currentTimeMillis();
    }

    public void dispose() {
        this.isDisposed = true;
        this.closeTables(this.tables);
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    private void closeTables(Map<String, HTable> tables) {
        for (String tableName : tables.keySet()) {
            try {
                HTable table = tables.get(tableName);
                table.close();
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

