/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neodatis.query;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.neodatis.NeoDatisStoreManager;
import org.datanucleus.store.neodatis.NeoDatisUtils;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.neodatis.odb.ODB;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.IQuery;

public class NativeQuery
extends AbstractJavaQuery {
    protected static final Localiser LOCALISER_NEODATIS = Localiser.getInstance((String)"org.datanucleus.store.neodatis.Localisation", (ClassLoader)(class$org$datanucleus$store$neodatis$NeoDatisStoreManager == null ? (class$org$datanucleus$store$neodatis$NeoDatisStoreManager = NativeQuery.class$("org.datanucleus.store.neodatis.NeoDatisStoreManager")) : class$org$datanucleus$store$neodatis$NeoDatisStoreManager).getClassLoader());
    org.neodatis.odb.core.query.nq.NativeQuery query = null;
    static /* synthetic */ Class class$org$datanucleus$store$neodatis$NeoDatisStoreManager;

    public NativeQuery(ObjectManager om) {
        this(om, null);
    }

    public NativeQuery(ObjectManager om, Object nativeQuery) {
        super(om);
        if (!(nativeQuery instanceof org.neodatis.odb.core.query.nq.NativeQuery)) {
            throw new NucleusUserException(LOCALISER_NEODATIS.msg("NeoDatis.Native.NeedsQuery"));
        }
        this.query = (org.neodatis.odb.core.query.nq.NativeQuery)nativeQuery;
        ((Query)this).candidateClassName = this.query.getObjectType().getName();
    }

    protected void compileInternal(boolean forExecute, Map parameterValues) {
    }

    protected boolean isCompiled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = ((Query)this).om.getStoreManager().getConnection(((Query)this).om);
        ODB odb = (ODB)mconn.getConnection();
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Query.LOCALISER.msg("021046", (Object)"Native", (Object)this.getSingleStringQuery()));
            }
            Objects resultSet = null;
            try {
                resultSet = odb.getObjects((IQuery)this.query);
            }
            catch (Exception e) {
                throw new NucleusDataStoreException("Exception thrown querying with native query", (Throwable)e);
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Query.LOCALISER.msg("021074", (Object)"Native", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            ArrayList results = new ArrayList(resultSet);
            AbstractClassMetaData cmd = null;
            Iterator iter = ((AbstractList)results).iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!((Query)this).om.getApiAdapter().isPersistable(obj)) continue;
                if (cmd == null) {
                    cmd = ((Query)this).om.getMetaDataManager().getMetaDataForClass(this.getCandidateClassName(), ((Query)this).om.getClassLoaderResolver());
                }
                NeoDatisUtils.prepareNeoDatisObjectForUse(obj, ((Query)this).om, odb, cmd, (NeoDatisStoreManager)((Query)this).om.getStoreManager());
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            mconn.release();
        }
    }

    protected boolean shouldReturnSingleRow() {
        return false;
    }

    public String getSingleStringQuery() {
        return "NeoDatis Native Query <" + ((Query)this).candidateClassName + ">";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

