/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neodatis.query;

import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.neodatis.odb.core.query.criteria.ComposedExpression;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.query.criteria.Where;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;

public class QueryToCriteriaMapper
extends AbstractExpressionEvaluator {
    protected static final Localiser LOCALISER_NEODATIS = Localiser.getInstance((String)"org.datanucleus.store.neodatis.Localisation", (ClassLoader)(class$org$datanucleus$store$neodatis$NeoDatisStoreManager == null ? (class$org$datanucleus$store$neodatis$NeoDatisStoreManager = QueryToCriteriaMapper.class$("org.datanucleus.store.neodatis.NeoDatisStoreManager")) : class$org$datanucleus$store$neodatis$NeoDatisStoreManager).getClassLoader());
    String candidateAlias;
    Expression filterExpr;
    Expression[] orderingExpr;
    Map parameters;
    SymbolTable symtbl;
    CriteriaQuery query;
    Stack stack = new Stack();
    static /* synthetic */ Class class$org$datanucleus$store$neodatis$NeoDatisStoreManager;

    public QueryToCriteriaMapper(CriteriaQuery query, QueryCompilation compilation, Map parameters) {
        this.parameters = parameters;
        this.orderingExpr = compilation.getExprOrdering();
        this.query = query;
        this.filterExpr = compilation.getExprFilter();
        this.symtbl = compilation.getSymbolTable();
        this.candidateAlias = compilation.getCandidateAlias();
    }

    public void compile() {
        Collection candidates;
        if (this.filterExpr != null) {
            Object where;
            this.filterExpr.evaluate((ExpressionEvaluator)this);
            if (!this.stack.empty() && (where = this.stack.pop()) instanceof ICriterion) {
                this.query.setCriterion((ICriterion)where);
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)"query.setCriterion(where);"));
                }
            }
        }
        if (this.orderingExpr != null) {
            StringBuffer orderFieldsAsc = new StringBuffer();
            StringBuffer orderFieldsDesc = new StringBuffer();
            for (int i = 0; i < this.orderingExpr.length; ++i) {
                String orderFieldName = ((PrimaryExpression)this.orderingExpr[i].getLeft()).getId();
                if (((OrderExpression)this.orderingExpr[i]).getSortOrder() == null || ((OrderExpression)this.orderingExpr[i]).getSortOrder().equals("ascending")) {
                    if (orderFieldsAsc.length() > 0) {
                        orderFieldsAsc.append(',');
                    }
                    orderFieldsAsc.append(orderFieldName);
                    continue;
                }
                if (orderFieldsDesc.length() > 0) {
                    orderFieldsDesc.append(',');
                }
                orderFieldsDesc.append(orderFieldName);
            }
            if (orderFieldsAsc.length() > 0) {
                this.query.orderByAsc(orderFieldsAsc.toString());
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("query.orderByAsc(" + orderFieldsAsc.toString() + ");")));
                }
            } else if (orderFieldsDesc.length() > 0) {
                this.query.orderByDesc(orderFieldsDesc.toString());
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("query.orderByDesc(" + orderFieldsDesc.toString() + ");")));
                }
            }
        }
        if (!this.symtbl.hasSymbol(this.candidateAlias) || this.parameters == null || this.parameters.get(this.candidateAlias) == null || !(this.parameters.get(this.candidateAlias) instanceof Collection) || (candidates = (Collection)this.parameters.get(this.candidateAlias)).isEmpty()) {
            // empty if block
        }
    }

    protected Object processOrExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof ICriterion && right instanceof ICriterion) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.or().add(" + left + ").add(" + right + ")")));
            }
        } else {
            if (left == Boolean.TRUE || right == Boolean.TRUE) {
                this.stack.push(Boolean.TRUE);
                return Boolean.TRUE;
            }
            this.stack.push(Boolean.FALSE);
            return Boolean.FALSE;
        }
        ComposedExpression boolExpr = Where.or().add((ICriterion)left).add((ICriterion)right);
        this.stack.push(boolExpr);
        return this.stack.peek();
    }

    protected Object processAndExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof ICriterion && right instanceof ICriterion) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.and().add(" + left + ").add(" + right + ")")));
            }
        } else {
            if (left == right && left == Boolean.TRUE) {
                this.stack.push(Boolean.TRUE);
                return Boolean.TRUE;
            }
            this.stack.push(Boolean.FALSE);
            return Boolean.FALSE;
        }
        ComposedExpression boolExpr = Where.and().add((ICriterion)left).add((ICriterion)right);
        this.stack.push(boolExpr);
        return this.stack.peek();
    }

    protected Object processEqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Object boolExpr = left instanceof PrimaryExpression && right instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_EQ, (PrimaryExpression)left, ((Literal)right).getLiteral()) : (right instanceof PrimaryExpression && left instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_EQ, (PrimaryExpression)right, ((Literal)left).getLiteral()) : (left instanceof PrimaryExpression && !(right instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_EQ, (PrimaryExpression)left, right) : (right instanceof PrimaryExpression && !(left instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_EQ, (PrimaryExpression)right, left) : (left.equals(right) ? Boolean.TRUE : Boolean.FALSE))));
        this.stack.push(boolExpr);
        return this.stack.peek();
    }

    protected Object processNoteqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Object boolExpr = left instanceof PrimaryExpression && right instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_NOTEQ, (PrimaryExpression)left, ((Literal)right).getLiteral()) : (right instanceof PrimaryExpression && left instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_NOTEQ, (PrimaryExpression)right, ((Literal)left).getLiteral()) : (left instanceof PrimaryExpression && !(right instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_NOTEQ, (PrimaryExpression)left, right) : (right instanceof PrimaryExpression && !(left instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_NOTEQ, (PrimaryExpression)right, left) : (left.equals(right) ? Boolean.FALSE : Boolean.TRUE))));
        this.stack.push(boolExpr);
        return this.stack.peek();
    }

    protected Object processGtExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Object boolExpr = left instanceof PrimaryExpression && right instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_GT, (PrimaryExpression)left, ((Literal)right).getLiteral()) : (right instanceof PrimaryExpression && left instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_LTEQ, (PrimaryExpression)right, ((Literal)left).getLiteral()) : (left instanceof InvokeExpression && right instanceof Literal ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_GT, (InvokeExpression)left, ((Literal)right).getLiteral()) : (right instanceof InvokeExpression && left instanceof Literal ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_LTEQ, (InvokeExpression)right, ((Literal)left).getLiteral()) : (left instanceof PrimaryExpression && !(right instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_GT, (PrimaryExpression)left, right) : (right instanceof PrimaryExpression && !(left instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_LTEQ, (PrimaryExpression)right, left) : (left instanceof InvokeExpression && !(right instanceof Expression) ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_GT, (InvokeExpression)left, right) : (right instanceof InvokeExpression && !(left instanceof Expression) ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_LTEQ, (InvokeExpression)right, left) : (left.equals(right) ? Boolean.FALSE : Boolean.TRUE))))))));
        this.stack.push(boolExpr);
        return this.stack.peek();
    }

    protected Object processLtExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Object boolExpr = left instanceof PrimaryExpression && right instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_LT, (PrimaryExpression)left, ((Literal)right).getLiteral()) : (right instanceof PrimaryExpression && left instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_GTEQ, (PrimaryExpression)right, ((Literal)left).getLiteral()) : (left instanceof InvokeExpression && right instanceof Literal ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_LT, (InvokeExpression)left, ((Literal)right).getLiteral()) : (right instanceof InvokeExpression && left instanceof Literal ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_GTEQ, (InvokeExpression)right, ((Literal)left).getLiteral()) : (left instanceof PrimaryExpression && !(right instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_LT, (PrimaryExpression)left, right) : (right instanceof PrimaryExpression && !(left instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_GTEQ, (PrimaryExpression)right, left) : (left instanceof InvokeExpression && !(right instanceof Expression) ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_LT, (InvokeExpression)left, right) : (right instanceof InvokeExpression && !(left instanceof Expression) ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_GTEQ, (InvokeExpression)right, left) : (left.equals(right) ? Boolean.FALSE : Boolean.TRUE))))))));
        this.stack.push(boolExpr);
        return this.stack.peek();
    }

    protected Object processGteqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Object boolExpr = left instanceof PrimaryExpression && right instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_GTEQ, (PrimaryExpression)left, ((Literal)right).getLiteral()) : (right instanceof PrimaryExpression && left instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_LT, (PrimaryExpression)right, ((Literal)left).getLiteral()) : (left instanceof InvokeExpression && right instanceof Literal ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_GTEQ, (InvokeExpression)left, ((Literal)right).getLiteral()) : (right instanceof InvokeExpression && left instanceof Literal ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_LT, (InvokeExpression)right, ((Literal)left).getLiteral()) : (left instanceof PrimaryExpression && !(right instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_GTEQ, (PrimaryExpression)left, right) : (right instanceof PrimaryExpression && !(left instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_LT, (PrimaryExpression)right, left) : (left instanceof InvokeExpression && !(right instanceof Expression) ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_GTEQ, (InvokeExpression)left, right) : (right instanceof InvokeExpression && !(left instanceof Expression) ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_LT, (InvokeExpression)right, left) : (left.equals(right) ? Boolean.FALSE : Boolean.TRUE))))))));
        this.stack.push(boolExpr);
        return this.stack.peek();
    }

    protected Object processLteqExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        Object boolExpr = left instanceof PrimaryExpression && right instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_LTEQ, (PrimaryExpression)left, ((Literal)right).getLiteral()) : (right instanceof PrimaryExpression && left instanceof Literal ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_GT, (PrimaryExpression)right, ((Literal)left).getLiteral()) : (left instanceof InvokeExpression && right instanceof Literal ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_LTEQ, (InvokeExpression)left, ((Literal)right).getLiteral()) : (right instanceof InvokeExpression && left instanceof Literal ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_GT, (InvokeExpression)right, ((Literal)left).getLiteral()) : (left instanceof PrimaryExpression && !(right instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_LTEQ, (PrimaryExpression)left, right) : (right instanceof PrimaryExpression && !(left instanceof Expression) ? this.getRelationalExprForPrimaryLiteralValue((Expression.Operator)Expression.OP_GT, (PrimaryExpression)right, left) : (left instanceof InvokeExpression && !(right instanceof Expression) ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_LTEQ, (InvokeExpression)left, right) : (right instanceof InvokeExpression && !(left instanceof Expression) ? this.getRelationalExprForInvokeLiteralValue((Expression.Operator)Expression.OP_GT, (InvokeExpression)right, left) : (left.equals(right) ? Boolean.FALSE : Boolean.TRUE))))))));
        this.stack.push(boolExpr);
        return this.stack.peek();
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Object value;
        Object e = value = this.parameters != null ? (Object)this.parameters.get(expr.getId()) : null;
        if (value != null) {
            this.stack.push(value);
            return value;
        }
        this.stack.push(expr);
        return expr;
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        Object value = QueryUtils.getValueForParameterExpression((Map)this.parameters, (ParameterExpression)expr);
        this.stack.push(value);
        return value;
    }

    protected Object processInvokeExpression(InvokeExpression invokeExpr) {
        Expression invokedExpr = invokeExpr.getLeft();
        String method = invokeExpr.getOperation();
        if (invokedExpr instanceof PrimaryExpression) {
            String field = ((PrimaryExpression)invokedExpr).getId();
            if (method.equals("startsWith")) {
                Literal param = (Literal)invokeExpr.getArguments().get(0);
                String arg = null;
                if (param.getLiteral() instanceof String) {
                    arg = (String)param.getLiteral();
                } else if (param.getLiteral() instanceof Character) {
                    arg = ((Character)param.getLiteral()).toString();
                } else if (param.getLiteral() instanceof Number) {
                    arg = ((Number)param.getLiteral()).toString();
                }
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.like(" + field + ", '" + arg + "%')")));
                }
                ICriterion boolExpr = Where.like((String)field, (String)(arg + "%"));
                this.stack.push(boolExpr);
                return boolExpr;
            }
            if (method.equals("endsWith")) {
                Literal param = (Literal)invokeExpr.getArguments().get(0);
                String arg = null;
                if (param.getLiteral() instanceof String) {
                    arg = (String)param.getLiteral();
                } else if (param.getLiteral() instanceof Character) {
                    arg = ((Character)param.getLiteral()).toString();
                } else if (param.getLiteral() instanceof Number) {
                    arg = ((Number)param.getLiteral()).toString();
                }
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.like(" + field + ", '%" + arg + "')")));
                }
                ICriterion boolExpr = Where.like((String)field, (String)("%" + arg));
                this.stack.push(boolExpr);
                return boolExpr;
            }
            if (method.equals("size")) {
                this.stack.push(invokeExpr);
                return invokeExpr;
            }
            if (method.equals("contains")) {
                Object obj = invokeExpr.getArguments().get(0);
                if (obj instanceof Literal) {
                    Object elementValue = ((Literal)obj).getLiteral();
                    ICriterion boolExpr = Where.contain((String)field, (Object)elementValue);
                    this.stack.push(boolExpr);
                    return boolExpr;
                }
                throw new NucleusException("Method " + method + " is only currently supported with a literal argument for JDOQL with NeoDatis");
            }
            if (method.equals("isEmpty")) {
                ICriterion boolExpr = Where.sizeEq((String)field, (int)0);
                this.stack.push(boolExpr);
                return boolExpr;
            }
            throw new NucleusException("Method " + method + " is not currently supported with JDOQL for NeoDatis");
        }
        throw new NucleusException("Attempt to invoke " + method + " on " + invokedExpr + " but this is not currently supported by NeoDatis JDOQL");
    }

    protected Object processLiteral(Literal expr) {
        this.stack.push(expr);
        return expr;
    }

    private String getPathForPrimaryExpression(PrimaryExpression expr) {
        String firstTuple = (String)expr.getTuples().iterator().next();
        String exprPath = expr.getId();
        if (firstTuple.equals(this.candidateAlias)) {
            exprPath = exprPath.substring(this.candidateAlias.length() + 1);
        }
        return exprPath;
    }

    private Object getRelationalExprForPrimaryLiteralValue(Expression.Operator op, PrimaryExpression fieldPrimary, Object literalValue) {
        ICriterion boolExpr = null;
        String fieldPath = this.getPathForPrimaryExpression(fieldPrimary);
        if (literalValue instanceof Integer) {
            int intVal = (Integer)literalValue;
            if (op == Expression.OP_GT) {
                boolExpr = Where.gt((String)fieldPath, (int)intVal);
            } else if (op == Expression.OP_LT) {
                boolExpr = Where.lt((String)fieldPath, (int)intVal);
            } else if (op == Expression.OP_GTEQ) {
                boolExpr = Where.ge((String)fieldPath, (int)intVal);
            } else if (op == Expression.OP_LTEQ) {
                boolExpr = Where.le((String)fieldPath, (int)intVal);
            } else if (op == Expression.OP_EQ) {
                boolExpr = Where.equal((String)fieldPath, (int)intVal);
            } else if (op == Expression.OP_NOTEQ) {
                boolExpr = Where.not((ICriterion)Where.equal((String)fieldPath, (int)intVal));
            }
        } else if (literalValue instanceof Long) {
            long longVal = (Long)literalValue;
            if (op == Expression.OP_GT) {
                boolExpr = Where.gt((String)fieldPath, (long)longVal);
            } else if (op == Expression.OP_LT) {
                boolExpr = Where.lt((String)fieldPath, (long)longVal);
            } else if (op == Expression.OP_GTEQ) {
                boolExpr = Where.ge((String)fieldPath, (long)longVal);
            } else if (op == Expression.OP_LTEQ) {
                boolExpr = Where.le((String)fieldPath, (long)longVal);
            } else if (op == Expression.OP_EQ) {
                boolExpr = Where.equal((String)fieldPath, (long)longVal);
            } else if (op == Expression.OP_NOTEQ) {
                boolExpr = Where.not((ICriterion)Where.equal((String)fieldPath, (long)longVal));
            }
        } else if (literalValue instanceof Short) {
            short shortVal = (Short)literalValue;
            if (op == Expression.OP_GT) {
                boolExpr = Where.gt((String)fieldPath, (short)shortVal);
            } else if (op == Expression.OP_LT) {
                boolExpr = Where.lt((String)fieldPath, (short)shortVal);
            } else if (op == Expression.OP_GTEQ) {
                boolExpr = Where.ge((String)fieldPath, (short)shortVal);
            } else if (op == Expression.OP_LTEQ) {
                boolExpr = Where.le((String)fieldPath, (short)shortVal);
            } else if (op == Expression.OP_EQ) {
                boolExpr = Where.equal((String)fieldPath, (short)shortVal);
            } else if (op == Expression.OP_NOTEQ) {
                boolExpr = Where.not((ICriterion)Where.equal((String)fieldPath, (short)shortVal));
            }
        } else if (literalValue instanceof Double) {
            double doubleVal = (Double)literalValue;
            if (op == Expression.OP_GT) {
                boolExpr = Where.gt((String)fieldPath, (double)doubleVal);
            } else if (op == Expression.OP_LT) {
                boolExpr = Where.lt((String)fieldPath, (double)doubleVal);
            } else if (op == Expression.OP_GTEQ) {
                boolExpr = Where.ge((String)fieldPath, (double)doubleVal);
            } else if (op == Expression.OP_LTEQ) {
                boolExpr = Where.le((String)fieldPath, (double)doubleVal);
            } else if (op == Expression.OP_EQ) {
                boolExpr = Where.equal((String)fieldPath, (double)doubleVal);
            } else if (op == Expression.OP_NOTEQ) {
                boolExpr = Where.not((ICriterion)Where.equal((String)fieldPath, (double)doubleVal));
            }
        } else if (literalValue instanceof Float) {
            float floatVal = ((Float)literalValue).floatValue();
            if (op == Expression.OP_GT) {
                boolExpr = Where.gt((String)fieldPath, (float)floatVal);
            } else if (op == Expression.OP_LT) {
                boolExpr = Where.lt((String)fieldPath, (float)floatVal);
            } else if (op == Expression.OP_GTEQ) {
                boolExpr = Where.ge((String)fieldPath, (float)floatVal);
            } else if (op == Expression.OP_LTEQ) {
                boolExpr = Where.le((String)fieldPath, (float)floatVal);
            } else if (op == Expression.OP_EQ) {
                boolExpr = Where.equal((String)fieldPath, (float)floatVal);
            } else if (op == Expression.OP_NOTEQ) {
                boolExpr = Where.not((ICriterion)Where.equal((String)fieldPath, (float)floatVal));
            }
        } else if (literalValue instanceof Byte) {
            byte byteVal = (Byte)literalValue;
            if (op == Expression.OP_GT) {
                boolExpr = Where.gt((String)fieldPath, (byte)byteVal);
            } else if (op == Expression.OP_LT) {
                boolExpr = Where.lt((String)fieldPath, (byte)byteVal);
            } else if (op == Expression.OP_GTEQ) {
                boolExpr = Where.ge((String)fieldPath, (byte)byteVal);
            } else if (op == Expression.OP_LTEQ) {
                boolExpr = Where.le((String)fieldPath, (byte)byteVal);
            } else if (op == Expression.OP_EQ) {
                boolExpr = Where.equal((String)fieldPath, (byte)byteVal);
            } else if (op == Expression.OP_NOTEQ) {
                boolExpr = Where.not((ICriterion)Where.equal((String)fieldPath, (byte)byteVal));
            }
        } else if (literalValue instanceof Character) {
            char charVal = ((Character)literalValue).charValue();
            if (op == Expression.OP_GT) {
                boolExpr = Where.gt((String)fieldPath, (char)charVal);
            } else if (op == Expression.OP_LT) {
                boolExpr = Where.lt((String)fieldPath, (char)charVal);
            } else if (op == Expression.OP_GTEQ) {
                boolExpr = Where.ge((String)fieldPath, (char)charVal);
            } else if (op == Expression.OP_LTEQ) {
                boolExpr = Where.le((String)fieldPath, (char)charVal);
            } else if (op == Expression.OP_EQ) {
                boolExpr = Where.equal((String)fieldPath, (char)charVal);
            } else if (op == Expression.OP_NOTEQ) {
                boolExpr = Where.not((ICriterion)Where.equal((String)fieldPath, (char)charVal));
            }
        } else if (literalValue instanceof Comparable) {
            if (op == Expression.OP_GT) {
                boolExpr = Where.gt((String)fieldPath, (Comparable)((Comparable)literalValue));
            } else if (op == Expression.OP_LT) {
                boolExpr = Where.lt((String)fieldPath, (Comparable)((Comparable)literalValue));
            } else if (op == Expression.OP_GTEQ) {
                boolExpr = Where.ge((String)fieldPath, (Comparable)((Comparable)literalValue));
            } else if (op == Expression.OP_LTEQ) {
                boolExpr = Where.le((String)fieldPath, (Comparable)((Comparable)literalValue));
            } else if (op == Expression.OP_EQ) {
                boolExpr = Where.equal((String)fieldPath, (Object)((Comparable)literalValue));
            } else if (op == Expression.OP_NOTEQ) {
                boolExpr = Where.not((ICriterion)Where.equal((String)fieldPath, (Object)((Comparable)literalValue)));
            }
        } else if (op == Expression.OP_EQ) {
            boolExpr = Where.equal((String)fieldPath, (Object)literalValue);
        } else if (op == Expression.OP_NOTEQ) {
            boolExpr = Where.not((ICriterion)Where.equal((String)fieldPath, (Object)literalValue));
        } else {
            throw new NucleusException("Query includes " + fieldPath + " " + op + " " + literalValue + " where the value is not of a supported NeoDatis query type for this relational operation");
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            if (op == Expression.OP_GT) {
                NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.gt(" + fieldPath + ", " + literalValue + ")")));
            } else if (op == Expression.OP_LT) {
                NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.lt(" + fieldPath + ", " + literalValue + ")")));
            } else if (op == Expression.OP_GTEQ) {
                NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.ge(" + fieldPath + ", " + literalValue + ")")));
            } else if (op == Expression.OP_LTEQ) {
                NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.le(" + fieldPath + ", " + literalValue + ")")));
            } else if (op == Expression.OP_EQ) {
                NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.equal(" + fieldPath + ", " + literalValue + ")")));
            } else if (op == Expression.OP_NOTEQ) {
                NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.not(Where.equal(" + fieldPath + ", " + literalValue + "))")));
            }
        }
        if (boolExpr == null) {
            throw new NucleusException("Unable to convert " + fieldPath + " " + op + " " + literalValue + " into Criteria query constraint");
        }
        return boolExpr;
    }

    private Object getRelationalExprForInvokeLiteralValue(Expression.Operator op, InvokeExpression invokeExpr, Object literalValue) {
        Object boolExpr = null;
        Expression invokedExpr = invokeExpr.getLeft();
        if (invokedExpr instanceof PrimaryExpression) {
            String field = ((PrimaryExpression)invokedExpr).getId();
            if (invokeExpr.getOperation().equals("size")) {
                int size = 0;
                if (literalValue instanceof Number) {
                    size = (Integer)literalValue;
                }
                if (op == Expression.OP_GT) {
                    Where.sizeGt((String)field, (int)size);
                } else if (op == Expression.OP_LT) {
                    Where.sizeLt((String)field, (int)size);
                } else if (op == Expression.OP_GTEQ) {
                    Where.sizeLt((String)field, (int)size);
                } else if (op == Expression.OP_LTEQ) {
                    Where.sizeLt((String)field, (int)size);
                } else if (op == Expression.OP_EQ) {
                    Where.sizeEq((String)field, (int)size);
                } else if (op == Expression.OP_NOTEQ) {
                    Where.sizeNe((String)field, (int)size);
                }
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    if (op == Expression.OP_GT) {
                        NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.sizeGt(" + field + ", " + literalValue + ")")));
                    } else if (op == Expression.OP_LT) {
                        NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.sizeLt(" + field + ", " + literalValue + ")")));
                    } else if (op == Expression.OP_GTEQ) {
                        NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.sizeGe(" + field + ", " + literalValue + ")")));
                    } else if (op == Expression.OP_LTEQ) {
                        NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.sizeLe(" + field + ", " + literalValue + ")")));
                    } else if (op == Expression.OP_EQ) {
                        NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.sizeEq(" + field + ", " + literalValue + ")")));
                    } else if (op == Expression.OP_NOTEQ) {
                        NucleusLogger.QUERY.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Criteria", (Object)("Where.sizeNe(" + field + ", " + literalValue + ")")));
                    }
                }
            } else {
                throw new NucleusException("Attempt to invoke method " + invokeExpr.getOperation() + " on field " + field + " but not currently supported by NeoDatis JDOQL");
            }
            if (boolExpr == null) {
                throw new NucleusException("Unable to convert " + field + " " + op + " " + literalValue + " into Criteria query constraint");
            }
            return boolExpr;
        }
        throw new NucleusException("Attempt to invoke " + invokeExpr.getOperation() + " on " + invokedExpr + " but this is not currently supported by NeoDatis JDOQL");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

