/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.util.NucleusLogger;

public class ObjectLiteral
extends ObjectExpression
implements SQLLiteral {
    private Object value;

    public ObjectLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.value = value;
        this.parameterName = parameterName;
        if (parameterName != null) {
            if (value != null) {
                this.subExprs = new SQLExpression.ColumnExpressionList();
                this.addSubexpressionsForValue(this.value, mapping);
            }
            if (mapping.getNumberOfDatastoreMappings() == 1) {
                this.st.appendParameter(parameterName, mapping, this.value);
            }
        } else {
            this.subExprs = new SQLExpression.ColumnExpressionList();
            if (value != null) {
                this.addSubexpressionsForValue(this.value, mapping);
            }
            this.st.append(this.subExprs.toString());
        }
    }

    private void addSubexpressionsForValue(Object value, JavaTypeMapping mapping) {
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        ClassLoaderResolver clr = this.stmt.getClassLoaderResolver();
        AbstractClassMetaData cmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(value.getClass(), clr);
        if (cmd != null) {
            int numCols = mapping.getNumberOfDatastoreMappings();
            for (int i = 0; i < numCols; ++i) {
                ColumnExpression colExpr = null;
                if (this.parameterName == null && mapping instanceof PersistableMapping) {
                    Object colValue = ((PersistableMapping)mapping).getValueForDatastoreMapping(this.stmt.getRDBMSManager().getOMFContext(), i, value);
                    colExpr = new ColumnExpression(this.stmt, colValue);
                } else {
                    colExpr = new ColumnExpression(this.stmt, this.parameterName, mapping, value, i);
                }
                this.subExprs.addExpression(colExpr);
            }
        } else {
            NucleusLogger.GENERAL.info((Object)">> ObjectLiteral doesn't yet cater for input identity values");
        }
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        this.addSubexpressionsToRelatedExpression(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (this.value == null) {
            return new NullLiteral(this.stmt, null, null, null).eq(expr);
        }
        if (expr instanceof ObjectExpression) {
            return ExpressionUtils.getEqualityExpressionForObjectExpressions(this, (ObjectExpression)expr, true);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        this.addSubexpressionsToRelatedExpression(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (this.value == null) {
            return new NullLiteral(this.stmt, null, null, null).ne(expr);
        }
        if (expr instanceof ObjectExpression) {
            return ExpressionUtils.getEqualityExpressionForObjectExpressions(this, (ObjectExpression)expr, false);
        }
        return super.ne(expr);
    }

    public String toString() {
        if (this.value != null) {
            return super.toString() + " = " + this.value.toString();
        }
        return super.toString() + " = NULL";
    }

    public void setNotParameter() {
        if (this.parameterName == null) {
            return;
        }
        this.parameterName = null;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        if (this.parameterName == null) {
            this.subExprs = new SQLExpression.ColumnExpressionList();
            if (this.value != null) {
                this.addSubexpressionsForValue(this.value, this.mapping);
            }
            this.st.append(this.subExprs.toString());
        } else {
            this.st.appendParameter(this.parameterName, this.mapping, this.value);
        }
    }
}

