/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.util.NucleusLogger;

public class MapContainsKeyMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        AbstractMemberMetaData mmd;
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(LOCALISER.msg("060016", (Object)"containsKey", (Object)"MapExpression", (Object)1));
        }
        MapExpression mapExpr = (MapExpression)expr;
        SQLExpression keyExpr = (SQLExpression)args.get(0);
        if (keyExpr.isParameter() && (mmd = mapExpr.getJavaTypeMapping().getMemberMetaData()) != null && mmd.getMap() != null) {
            Class keyCls = this.stmt.getQueryGenerator().getClassLoaderResolver().classForName(mmd.getMap().getKeyType());
            this.stmt.getQueryGenerator().bindParameter(keyExpr.getParameterName(), keyCls);
        }
        if (expr instanceof MapLiteral) {
            MapLiteral lit = (MapLiteral)expr;
            Map map = (Map)lit.getValue();
            if (map == null || map.size() == 0) {
                JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
                return new BooleanLiteral(this.stmt, m, Boolean.FALSE, null);
            }
            MapLiteral.MapKeyLiteral mapKeyLiteral = lit.getKeyLiteral();
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = mapKeyLiteral.getKeyExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                bExpr = bExpr == null ? elementExprs.get(i).eq(keyExpr) : ((BooleanExpression)bExpr).ior(elementExprs.get(i).eq(keyExpr));
            }
            bExpr.encloseInParentheses();
            return bExpr;
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER) {
            boolean needsSubquery = this.getNeedsSubquery();
            if (needsSubquery) {
                NucleusLogger.QUERY.debug((Object)("MapContainsKey on " + mapExpr + "(" + keyExpr + ") using SUBQUERY"));
                return this.containsAsSubquery(mapExpr, keyExpr);
            }
            NucleusLogger.QUERY.debug((Object)("MapContainsKey on " + mapExpr + "(" + keyExpr + ") using INNERJOIN"));
            return this.containsAsInnerJoin(mapExpr, keyExpr);
        }
        return this.containsAsSubquery(mapExpr, keyExpr);
    }

    protected boolean getNeedsSubquery() {
        Boolean hasNOT;
        boolean needsSubquery = false;
        Boolean hasOR = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.OR");
        if (hasOR != null && hasOR.booleanValue()) {
            needsSubquery = true;
        }
        if ((hasNOT = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.NOT")) != null && hasNOT.booleanValue()) {
            needsSubquery = true;
        }
        return needsSubquery;
    }

    protected SQLExpression containsAsInnerJoin(MapExpression mapExpr, SQLExpression keyExpr) {
        boolean keyIsUnbound = keyExpr instanceof UnboundExpression;
        String varName = null;
        if (keyIsUnbound) {
            varName = ((UnboundExpression)keyExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)(">> Map.containsKey binding unbound variable " + varName + " using INNER JOIN"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        MetaDataManager mmgr = storeMgr.getMetaDataManager();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(this.clr, mmgr);
        if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            MapTable mapTbl = (MapTable)storeMgr.getDatastoreContainerObject(mmd);
            SQLTable joinSqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), mapTbl, null, mapTbl.getOwnerMapping(), null, null);
            if (keyCmd != null) {
                DatastoreClass keyTbl = storeMgr.getDatastoreClass(keyCmd.getFullClassName(), this.clr);
                SQLTable keySqlTbl = this.stmt.innerJoin(joinSqlTbl, mapTbl.getKeyMapping(), (DatastoreContainerObject)keyTbl, null, keyTbl.getIdMapping(), null, null);
                if (keyIsUnbound) {
                    keyExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, keyCmd, keyExpr.getSQLTable(), keyExpr.getJavaTypeMapping());
                } else {
                    SQLExpression keyIdExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getIdMapping());
                    this.stmt.whereAnd(keyIdExpr.eq(keyExpr), true);
                }
            } else if (keyIsUnbound) {
                keyExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, mapTbl.getKeyMapping());
                this.stmt.getQueryGenerator().bindVariable(varName, keyCmd, keyExpr.getSQLTable(), keyExpr.getJavaTypeMapping());
            } else {
                SQLExpression keyIdExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, mapTbl.getKeyMapping());
                this.stmt.whereAnd(keyIdExpr.eq(keyExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(this.clr, mmgr);
            DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), this.clr);
            AbstractMemberMetaData valKeyMmd = valCmd.getMetaDataForMember(mmd.getKeyMetaData().getMappedBy());
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? valTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : valTbl.getExternalMapping(mmd, 5);
            SQLTable valSqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), (DatastoreContainerObject)valTbl, null, ownerMapping, null, null);
            if (keyCmd != null) {
                DatastoreClass keyTbl = storeMgr.getDatastoreClass(keyCmd.getFullClassName(), this.clr);
                SQLTable keySqlTbl = this.stmt.innerJoin(valSqlTbl, valTbl.getMemberMapping(valKeyMmd), (DatastoreContainerObject)keyTbl, null, keyTbl.getIdMapping(), null, null);
                if (keyIsUnbound) {
                    keyExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, keyCmd, keyExpr.getSQLTable(), keyExpr.getJavaTypeMapping());
                } else {
                    SQLExpression keyIdExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getIdMapping());
                    this.stmt.whereAnd(keyIdExpr.eq(keyExpr), true);
                }
            } else if (keyIsUnbound) {
                keyExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getMemberMapping(valKeyMmd));
                this.stmt.getQueryGenerator().bindVariable(varName, keyCmd, keyExpr.getSQLTable(), keyExpr.getJavaTypeMapping());
            } else {
                SQLExpression keyIdExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getMemberMapping(valKeyMmd));
                this.stmt.whereAnd(keyIdExpr.eq(keyExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            DatastoreClass keyTbl = storeMgr.getDatastoreClass(keyCmd.getFullClassName(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? keyTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTbl.getExternalMapping(mmd, 5);
            SQLTable keySqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), (DatastoreContainerObject)keyTbl, null, ownerMapping, null, null);
            if (keyIsUnbound) {
                keyExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getIdMapping());
                this.stmt.getQueryGenerator().bindVariable(varName, keyCmd, keyExpr.getSQLTable(), keyExpr.getJavaTypeMapping());
            } else {
                SQLExpression keyIdExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getIdMapping());
                this.stmt.whereAnd(keyIdExpr.eq(keyExpr), true);
            }
        }
        JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
        return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
    }

    protected SQLExpression containsAsSubquery(MapExpression mapExpr, SQLExpression keyExpr) {
        boolean keyIsUnbound = keyExpr instanceof UnboundExpression;
        String varName = null;
        if (keyIsUnbound) {
            varName = ((UnboundExpression)keyExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)(">> Map.containsKey binding unbound variable " + varName + " using SUBQUERY"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        MetaDataManager mmgr = storeMgr.getMetaDataManager();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(this.clr, mmgr);
        MapTable joinTbl = (MapTable)storeMgr.getDatastoreContainerObject(mmd);
        SQLStatement subStmt = null;
        if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            if (keyCmd == null) {
                subStmt = new SQLStatement(this.stmt, storeMgr, joinTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (keyIsUnbound) {
                    keyExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getKeyMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, keyCmd, keyExpr.getSQLTable(), keyExpr.getJavaTypeMapping());
                } else {
                    SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getKeyMapping());
                    subStmt.whereAnd(elemIdExpr.eq(keyExpr), true);
                }
            } else {
                DatastoreClass keyTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), this.clr);
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)keyTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), keyTbl.getIdMapping(), joinTbl, null, joinTbl.getKeyMapping(), null, null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (keyIsUnbound) {
                    keyExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, keyCmd, keyExpr.getSQLTable(), keyExpr.getJavaTypeMapping());
                } else {
                    SQLExpression keyIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyTbl.getIdMapping());
                    subStmt.whereAnd(keyIdExpr.eq(keyExpr), true);
                }
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(this.clr, mmgr);
            DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), this.clr);
            JavaTypeMapping ownerMapping = valTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy()));
            AbstractMemberMetaData valKeyMmd = valCmd.getMetaDataForMember(mmd.getKeyMetaData().getMappedBy());
            if (keyCmd == null) {
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)valTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (keyIsUnbound) {
                    keyExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getMemberMapping(valKeyMmd));
                    this.stmt.getQueryGenerator().bindVariable(varName, keyCmd, keyExpr.getSQLTable(), keyExpr.getJavaTypeMapping());
                } else {
                    JavaTypeMapping keyMapping = valTbl.getMemberMapping(valKeyMmd);
                    SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyMapping);
                    subStmt.whereAnd(elemIdExpr.eq(keyExpr), true);
                }
            } else {
                DatastoreClass keyTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), this.clr);
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)keyTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable valSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), keyTbl.getIdMapping(), (DatastoreContainerObject)valTbl, null, valTbl.getMemberMapping(valKeyMmd), null, null);
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, valSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (keyIsUnbound) {
                    keyExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, keyCmd, keyExpr.getSQLTable(), keyExpr.getJavaTypeMapping());
                } else {
                    SQLExpression keyIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyTbl.getIdMapping());
                    subStmt.whereAnd(keyIdExpr.eq(keyExpr), true);
                }
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            DatastoreClass keyTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? keyTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTbl.getExternalMapping(mmd, 5);
            subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)keyTbl, null, null);
            subStmt.setClassLoaderResolver(this.clr);
            JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
            subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
            SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
            SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
            subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
            if (keyIsUnbound) {
                keyExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyTbl.getIdMapping());
                this.stmt.getQueryGenerator().bindVariable(varName, keyCmd, keyExpr.getSQLTable(), keyExpr.getJavaTypeMapping());
            } else {
                JavaTypeMapping keyMapping = keyTbl.getIdMapping();
                SQLExpression keyIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyMapping);
                subStmt.whereAnd(keyIdExpr.eq(keyExpr), true);
            }
        }
        return new BooleanSubqueryExpression(this.stmt, "EXISTS", subStmt);
    }
}

