/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.mojo;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.dataset.datatype.IDataTypeFactory;

public abstract class AbstractDbUnitMojo
extends AbstractMojo {
    protected String driver;
    protected String username;
    protected String password;
    protected String url;
    protected String schema;
    protected Properties dbconfig;
    @Deprecated
    protected String dataTypeFactoryName = "org.dbunit.dataset.datatype.DefaultDataTypeFactory";
    @Deprecated
    protected boolean supportBatchStatement;
    @Deprecated
    protected boolean useQualifiedTableNames;
    @Deprecated
    protected boolean datatypeWarning;
    @Deprecated
    protected String escapePattern;
    @Deprecated
    protected boolean skipOracleRecycleBinTables;
    protected boolean skip;
    private Settings settings;
    private String settingsKey;
    @Deprecated
    protected String metadataHandlerName;
    @Deprecated
    private boolean caseSensitiveTableNames;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.loadUserInfoFromSettings();
    }

    IDatabaseConnection createConnection() throws Exception {
        Connection conn;
        Class<?> dc = Class.forName(this.driver);
        Driver driverInstance = (Driver)dc.newInstance();
        Properties info = new Properties();
        info.put("user", this.username);
        if (this.password != null) {
            info.put("password", this.password);
        }
        if ((conn = driverInstance.connect(this.url, info)) == null) {
            throw new SQLException("No suitable Driver for " + this.url);
        }
        conn.setAutoCommit(true);
        DatabaseConnection connection = new DatabaseConnection(conn, this.schema);
        DatabaseConfig config = connection.getConfig();
        this.initializeDbConfigWithOldProps(config);
        if (this.dbconfig != null) {
            this.getLog().debug((CharSequence)("Setting dbconfig properties on the database config. " + this.dbconfig));
            try {
                config.setPropertiesByString(this.dbconfig);
            }
            catch (DatabaseUnitException e) {
                throw new MojoExecutionException("Could not populate dbunit config object", (Exception)((Object)e));
            }
        } else {
            this.getLog().debug((CharSequence)"No dbconfig element specified");
        }
        return connection;
    }

    @Deprecated
    private void initializeDbConfigWithOldProps(DatabaseConfig config) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        config.setFeature("http://www.dbunit.org/features/batchedStatements", this.supportBatchStatement);
        config.setFeature("http://www.dbunit.org/features/qualifiedTableNames", this.useQualifiedTableNames);
        config.setFeature("http://www.dbunit.org/features/datatypeWarning", this.datatypeWarning);
        config.setFeature("http://www.dbunit.org/features/skipOracleRecycleBinTables", this.skipOracleRecycleBinTables);
        config.setFeature("http://www.dbunit.org/features/caseSensitiveTableNames", this.caseSensitiveTableNames);
        config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)this.escapePattern);
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new ForwardOnlyResultSetTableFactory());
        IDataTypeFactory dataTypeFactory = (IDataTypeFactory)Class.forName(this.dataTypeFactoryName).newInstance();
        config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)dataTypeFactory);
        IMetadataHandler metadataHandler = (IMetadataHandler)Class.forName(this.metadataHandlerName).newInstance();
        config.setProperty("http://www.dbunit.org/properties/metadataHandler", (Object)metadataHandler);
    }

    private void loadUserInfoFromSettings() throws MojoExecutionException {
        Server server;
        if (this.settingsKey == null) {
            this.settingsKey = this.url;
        }
        if ((this.username == null || this.password == null) && this.settings != null && (server = this.settings.getServer(this.settingsKey)) != null) {
            if (this.username == null) {
                this.username = server.getUsername();
            }
            if (this.password == null) {
                this.password = server.getPassword();
            }
        }
        if (this.username == null) {
            this.username = "";
        }
        if (this.password == null) {
            this.password = "";
        }
    }
}

