/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.control;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.duracloud.client.report.StorageReportManager;
import org.duracloud.client.report.error.NotFoundException;
import org.duracloud.client.report.error.ReportException;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.duradmin.control.StorageSummary;
import org.duracloud.duradmin.control.StorageSummaryCache;
import org.duracloud.duradmin.control.StorageSummaryCacheImpl;
import org.duracloud.reportdata.storage.StorageReport;
import org.duracloud.reportdata.storage.metrics.SpaceMetrics;
import org.duracloud.reportdata.storage.metrics.StorageProviderMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StorageSummaryCacheImpl
implements StorageSummaryCache {
    private Logger log = LoggerFactory.getLogger(StorageSummaryCacheImpl.class);
    private StorageReportManager storageReportManager;
    private Map<String, List<StorageSummary>> summaryListCache = new HashMap();
    private static final DateFormat REPORT_ID_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final int DEFAULT_CACHE_RELOAD_FREQUENCY_IN_MINUTES = 60;
    private Timer timer = null;
    private boolean running = false;
    private int cacheReloadFrequencyInMinutes = 60;

    @Autowired
    public StorageSummaryCacheImpl(StorageReportManager storageReportManager) {
        this(storageReportManager, 60);
    }

    public StorageSummaryCacheImpl(StorageReportManager storageReportManager, int cacheReloadFrequencyInMinutes) {
        if (storageReportManager == null) {
            throw new IllegalArgumentException("The storageReportManager must be non-null");
        }
        this.storageReportManager = storageReportManager;
        this.cacheReloadFrequencyInMinutes = cacheReloadFrequencyInMinutes;
    }

    public void init() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.running = false;
        long frequency = this.cacheReloadFrequencyInMinutes * 60 * 1000;
        this.timer.schedule((TimerTask)new LoadTimerTask(this), new Date(), frequency);
    }

    private Long parseDateFromReportId(String reportId) {
        String dateString = reportId.replace("report/storage-report-", "").replace(".xml", "");
        try {
            return REPORT_ID_DATE_FORMAT.parse(dateString).getTime();
        }
        catch (ParseException e) {
            throw new DuraCloudRuntimeException((Throwable)e);
        }
    }

    private void loadCache() throws Exception {
        this.log.info("retrieving report list...");
        List list = this.storageReportManager.getStorageReportList();
        this.log.info("approximately " + list.size() + " reports in list");
        HashMap newCache = new HashMap();
        for (String reportId : list) {
            if (!reportId.endsWith("xml")) continue;
            this.appendSummaries(newCache, reportId);
        }
        this.summaryListCache = newCache;
    }

    private void appendSummaries(Map<String, List<StorageSummary>> cache, String reportId) throws NotFoundException, ReportException {
        Long dateInMs = this.parseDateFromReportId(reportId);
        StorageReport report = this.storageReportManager.getStorageReport(reportId);
        for (StorageProviderMetrics spm : report.getStorageMetrics().getStorageProviderMetrics()) {
            String storeId = spm.getStorageProviderId();
            StorageSummary sps = new StorageSummary(dateInMs.longValue(), spm.getTotalSize(), spm.getTotalItems(), reportId);
            this.appendToSummaryList(storeId, sps, cache);
            for (SpaceMetrics spaceMetrics : spm.getSpaceMetrics()) {
                StorageSummary spaceSummary = new StorageSummary(dateInMs.longValue(), spaceMetrics.getTotalSize(), spaceMetrics.getTotalItems(), reportId);
                this.appendToSummaryList(storeId, spaceMetrics.getSpaceName(), spaceSummary, cache);
            }
        }
        this.log.info("added storage summaries extracted from " + reportId);
    }

    private void appendToSummaryList(String storeId, StorageSummary summary, Map<String, List<StorageSummary>> cache) {
        this.appendToSummaryList(storeId, null, summary, cache);
    }

    private void appendToSummaryList(String storeId, String spaceId, StorageSummary summary, Map<String, List<StorageSummary>> cache) {
        List list = this.getSummaryList(storeId, spaceId, cache);
        list.add(summary);
    }

    private List<StorageSummary> getSummaryList(String storeId, String spaceId, Map<String, List<StorageSummary>> cache) {
        String key = this.formatKey(storeId, spaceId);
        List<StorageSummary> summaryList = cache.get(key);
        if (summaryList == null) {
            summaryList = new LinkedList<StorageSummary>();
            cache.put(key, summaryList);
        }
        return summaryList;
    }

    public List<StorageSummary> getSummaries(String storeId, String spaceId) {
        if (storeId == null) {
            throw new IllegalArgumentException("storeId must be non-null");
        }
        return this.getSummaryList(storeId, spaceId, this.summaryListCache);
    }

    private String formatKey(String storeId, String spaceId) {
        return storeId + (spaceId != null ? "/" + spaceId : "");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    static /* synthetic */ boolean access$000(StorageSummaryCacheImpl x0) {
        return x0.running;
    }

    static /* synthetic */ Logger access$100(StorageSummaryCacheImpl x0) {
        return x0.log;
    }

    static /* synthetic */ boolean access$002(StorageSummaryCacheImpl x0, boolean x1) {
        x0.running = x1;
        return x0.running;
    }

    static /* synthetic */ void access$200(StorageSummaryCacheImpl x0) throws Exception {
        x0.loadCache();
    }
}

