/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.duracloud.client.ContentStore;
import org.duracloud.error.NotFoundException;
import org.duracloud.error.UnauthorizedException;
import org.duracloud.syncui.domain.SpaceForm;
import org.duracloud.syncui.service.ContentStoreFactory;
import org.duracloud.syncui.validation.SpaceWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SpaceWritableValidator
implements ConstraintValidator<SpaceWritable, SpaceForm> {
    private SpaceWritable constraintAnnotation;
    private ContentStoreFactory contentStoreFactory;
    private static Logger log = LoggerFactory.getLogger(SpaceWritableValidator.class);

    @Autowired
    public SpaceWritableValidator(ContentStoreFactory contentStoreFactory) {
        this.contentStoreFactory = contentStoreFactory;
    }

    public boolean isValid(SpaceForm spaceForm, ConstraintValidatorContext context) {
        try {
            ContentStore contentStore = this.contentStoreFactory.create(spaceForm.getCredentialsForm(), false);
            String spaceId = spaceForm.getSpaceId();
            String contentId = ".duracloud-dummy-item-" + System.currentTimeMillis();
            contentStore.deleteContent(spaceId, contentId);
            return true;
        }
        catch (UnauthorizedException e) {
            log.error(e.getMessage(), (Throwable)e);
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.constraintAnnotation.message()).addNode("spaceId").addConstraintViolation();
            return false;
        }
        catch (NotFoundException ex) {
            return true;
        }
        catch (Exception ex) {
            throw new RuntimeException("unexpected exception!:" + ex.getMessage(), ex);
        }
    }

    public void initialize(SpaceWritable constraintAnnotation) {
        this.constraintAnnotation = constraintAnnotation;
    }
}

