/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.stream;

import java.io.IOException;
import java.io.InputStream;
import org.duracloud.chunk.stream.CountingDigestInputStream;
import org.duracloud.common.util.MimetypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkInputStream
extends InputStream {
    private final Logger log = LoggerFactory.getLogger(ChunkInputStream.class);
    private static final MimetypeUtil mimeUtil = new MimetypeUtil();
    private String chunkId;
    private CountingDigestInputStream stream;
    private long chunkSize;
    private String mimetype;
    private boolean preserveMD5;

    public ChunkInputStream(String chunkId, InputStream inputStream, long chunkSize, boolean preserveMD5) {
        this.stream = new CountingDigestInputStream(inputStream, preserveMD5);
        this.chunkId = chunkId;
        this.chunkSize = chunkSize;
        this.preserveMD5 = preserveMD5;
        this.mimetype = mimeUtil.getMimeType(chunkId);
    }

    @Override
    public int read() throws IOException {
        if (this.stream.getByteCount() >= this.chunkSize) {
            return -1;
        }
        return this.stream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long byteCount = this.stream.getByteCount();
        if (byteCount >= this.chunkSize) {
            return -1;
        }
        long bytesRemainingInChunk = this.chunkSize - byteCount;
        if (bytesRemainingInChunk <= (long)len) {
            len = (int)bytesRemainingInChunk;
        }
        return this.stream.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
    }

    public String getMD5() {
        return this.stream.getMD5();
    }

    public long numBytesRead() {
        return this.stream.getByteCount();
    }

    public String getChunkId() {
        return this.chunkId;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public boolean md5Preserved() {
        return this.preserveMD5;
    }
}

