/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client.impl;

import java.util.Map;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.client.impl.CachingContentStoreImpl;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.error.ContentStoreException;
import org.duracloud.storage.domain.StorageAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingContentStoreManagerImpl
extends ContentStoreManagerImpl {
    private static final Logger log = LoggerFactory.getLogger(CachingContentStoreManagerImpl.class);
    private Map<String, ContentStore> contentStores;
    private ContentStore primaryContentStore;

    public CachingContentStoreManagerImpl(String host, String port, String context) {
        super(host, port, context);
    }

    @Override
    public Map<String, ContentStore> getContentStores() throws ContentStoreException {
        log.debug("enter: getContentStores()");
        if (null == this.contentStores) {
            log.debug("populating cache.");
            this.contentStores = super.getContentStores();
        }
        return this.contentStores;
    }

    @Override
    public ContentStore getPrimaryContentStore() throws ContentStoreException {
        log.debug("enter: getPrimaryContentStore()");
        if (null == this.primaryContentStore) {
            log.debug("populating cache.");
            this.primaryContentStore = super.getPrimaryContentStore();
        }
        return this.primaryContentStore;
    }

    @Override
    protected ContentStore newContentStoreImpl(StorageAccount acct) {
        return new CachingContentStoreImpl(this.getBaseURL(), acct.getType(), acct.getId(), this.getRestHelper());
    }

    @Override
    protected void setRestHelper(RestHttpHelper restHelper) {
        super.setRestHelper(restHelper);
    }
}

