/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.stream;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import org.duracloud.common.util.ChecksumUtil;

public class ChecksumInputStream
extends FilterInputStream {
    private String providedChecksum;

    public ChecksumInputStream(InputStream inputStream, String checksum) {
        super(ChecksumInputStream.wrapStream(inputStream, checksum));
        this.providedChecksum = checksum;
    }

    private static InputStream wrapStream(InputStream inputStream, String checksum) {
        InputStream stream = inputStream;
        if (checksum == null) {
            stream = ChecksumUtil.wrapStream(inputStream, ChecksumUtil.Algorithm.MD5);
        }
        return stream;
    }

    public String getMD5() {
        if (this.providedChecksum == null) {
            this.providedChecksum = ChecksumUtil.getChecksum((DigestInputStream)this.in);
        }
        return this.providedChecksum;
    }

    public byte[] getMD5Bytes() {
        if (this.providedChecksum == null) {
            this.providedChecksum = this.getMD5();
        }
        return ChecksumUtil.hexStringToByteArray(this.providedChecksum);
    }
}

