/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.stitch.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.duracloud.common.model.ContentItem;
import org.duracloud.domain.Content;
import org.duracloud.stitch.datasource.DataSource;
import org.duracloud.stitch.stream.MultiContentInputStreamListener;

public class MultiContentInputStream
extends InputStream {
    private DataSource dataSource;
    private Iterator<ContentItem> contents;
    private InputStream currentStream;
    private MultiContentInputStreamListener listener;
    private ContentItem currentItem;

    public MultiContentInputStream(DataSource dataSource, List<ContentItem> contentItems, MultiContentInputStreamListener listener) {
        this.dataSource = dataSource;
        this.contents = contentItems.iterator();
        this.currentStream = null;
        this.listener = listener;
    }

    public MultiContentInputStream(DataSource dataSource, List<ContentItem> contentItems) {
        this(dataSource, contentItems, null);
    }

    @Override
    public int read() throws IOException {
        int bite;
        if (null == this.currentStream) {
            if (this.contents.hasNext()) {
                this.currentStream = this.nextStream();
            } else {
                return -1;
            }
        }
        if (-1 == (bite = this.currentStream.read())) {
            if (this.contents.hasNext()) {
                this.currentStream = this.nextStream();
                bite = this.currentStream.read();
            } else {
                this.notifyContentIdRead();
            }
        }
        return bite;
    }

    private InputStream nextStream() {
        if (this.currentStream != null) {
            IOUtils.closeQuietly(this.currentStream);
            this.notifyContentIdRead();
        }
        this.currentItem = this.contents.next();
        return this.getStream(this.currentItem);
    }

    protected void notifyContentIdRead() {
        if (this.listener != null && this.currentItem != null) {
            this.listener.contentIdRead(this.currentItem.getContentId());
            this.currentItem = null;
        }
    }

    private InputStream getStream(ContentItem contentItem) {
        Content content = this.dataSource.getContent(contentItem.getSpaceId(), contentItem.getContentId());
        return content.getStream();
    }
}

