/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.backup;

import java.io.File;
import java.util.List;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.util.DirectoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedListBackupManager
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ChangedListBackupManager.class);
    public static final int SAVED_BACKUPS = 3;
    protected static final int DEFAULT_SLEEP_TIME = 5000;
    private File backupDir;
    private long backupFrequency;
    private ChangedList changedList;
    private boolean continueBackup;
    private long changedListVersion;
    private List<File> contentDirs;
    private boolean backingUp = false;

    public ChangedListBackupManager(ChangedList changedList, File backupDir, long backupFrequency, List<File> contentDirs) {
        this.backupDir = new File(backupDir, "changeList");
        if (!this.backupDir.exists()) {
            this.backupDir.mkdir();
        }
        this.backupFrequency = backupFrequency;
        this.changedList = changedList;
        this.contentDirs = contentDirs;
        this.continueBackup = true;
    }

    public long loadBackup() {
        long backupTime = -1L;
        File[] backupDirFiles = this.getSortedBackupDirFiles();
        if (backupDirFiles.length > 0) {
            File latestBackup = backupDirFiles[0];
            try {
                backupTime = Long.parseLong(latestBackup.getName());
                this.changedList.restore(latestBackup, this.contentDirs);
            }
            catch (NumberFormatException e) {
                this.logger.error("Unable to load changed list backup. File in changed list backup dir has invalid name: " + latestBackup.getName());
                backupTime = -1L;
            }
        }
        return backupTime;
    }

    @Override
    public void run() {
        while (this.continueBackup) {
            if (this.changedListVersion < this.changedList.getVersion()) {
                this.cleanupBackupDir(3);
                String filename = String.valueOf(System.currentTimeMillis());
                File persistFile = new File(this.backupDir, filename);
                this.backingUp = true;
                this.changedListVersion = this.changedList.persist(persistFile);
                this.backingUp = false;
            }
            this.sleepAndCheck(this.backupFrequency);
        }
    }

    private void sleepAndCheck(long backupFrequency) {
        long sleepTime = 5000L;
        for (long sleepCompleted = 0L; this.continueBackup && sleepCompleted < backupFrequency; sleepCompleted += sleepTime) {
            this.sleep(sleepTime);
        }
    }

    protected void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            this.logger.warn("ChangedListBackupManager thread interrupted");
        }
    }

    private void cleanupBackupDir(int keep) {
        File[] backupDirFiles = this.getSortedBackupDirFiles();
        if (backupDirFiles.length > keep) {
            for (int i = keep; i < backupDirFiles.length; ++i) {
                backupDirFiles[i].delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        while (this.backingUp) {
            this.sleep(100L);
        }
        ChangedListBackupManager changedListBackupManager = this;
        synchronized (changedListBackupManager) {
            this.cleanupBackupDir(0);
        }
    }

    private File[] getSortedBackupDirFiles() {
        return DirectoryUtil.listFilesSortedByModDate(this.backupDir);
    }

    public void endBackup() {
        this.continueBackup = false;
    }

    public boolean hasBackups() {
        return this.getSortedBackupDirFiles().length > 0;
    }
}

