/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.domain;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.duracloud.client.ContentStore;
import org.duracloud.error.ContentStoreException;
import org.duracloud.syncui.domain.DuracloudCredentialsCoherenceChecker;
import org.duracloud.syncui.domain.DuracloudCredentialsForm;
import org.duracloud.syncui.service.ContentStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DuracloudCredentialsCoherenceCheckerValidator
implements ConstraintValidator<DuracloudCredentialsCoherenceChecker, DuracloudCredentialsForm> {
    private static Logger log = LoggerFactory.getLogger(DuracloudCredentialsCoherenceCheckerValidator.class);
    private ContentStoreFactory contentStoreFactory;

    @Autowired
    public DuracloudCredentialsCoherenceCheckerValidator(ContentStoreFactory contentStoreFactory) {
        this.contentStoreFactory = contentStoreFactory;
    }

    public void initialize(DuracloudCredentialsCoherenceChecker constraintAnnotation) {
    }

    public boolean isValid(DuracloudCredentialsForm value, ConstraintValidatorContext context) {
        try {
            ContentStore cs = this.contentStoreFactory.create(value);
            return cs != null;
        }
        catch (ContentStoreException ex) {
            log.warn("invalid credentials: " + ex.getMessage(), ex);
            return false;
        }
    }
}

