/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.model;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.BaseEntity;

@Entity
public class UserInvitation
extends BaseEntity {
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    @JoinColumn(name="account_id", nullable=true, columnDefinition="bigint(20)")
    private AccountInfo account;
    private String accountName;
    private String accountOrg;
    private String accountDep;
    private String accountSubdomain;
    private String adminUsername;
    private String userEmail;
    private Date creationDate;
    private Date expirationDate;
    private String redemptionCode;

    public UserInvitation() {
    }

    public UserInvitation(Long id, AccountInfo account, String accountName, String accountOrg, String accountDep, String accountSubdomain, String adminUsername, String userEmail, int expirationDays, String redemptionCode) {
        this.id = id;
        this.account = account;
        this.accountName = accountName;
        this.accountOrg = accountOrg;
        this.accountDep = accountDep;
        this.accountSubdomain = accountSubdomain;
        this.adminUsername = adminUsername;
        this.userEmail = userEmail;
        this.creationDate = new Date();
        long expMillis = expirationDays * 86400000;
        this.expirationDate = new Date(this.creationDate.getTime() + expMillis);
        this.redemptionCode = redemptionCode;
    }

    public AccountInfo getAccount() {
        return this.account;
    }

    public void setAccount(AccountInfo account) {
        this.account = account;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountOrg() {
        return this.accountOrg;
    }

    public void setAccountOrg(String accountOrg) {
        this.accountOrg = accountOrg;
    }

    public String getAccountDep() {
        return this.accountDep;
    }

    public void setAccountDep(String accountDep) {
        this.accountDep = accountDep;
    }

    public String getAccountSubdomain() {
        return this.accountSubdomain;
    }

    public void setAccountSubdomain(String accountSubdomain) {
        this.accountSubdomain = accountSubdomain;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getRedemptionCode() {
        return this.redemptionCode;
    }

    public void setRedemptionCode(String redemptionCode) {
        this.redemptionCode = redemptionCode;
    }

    public String toString() {
        return "UserInvitation[id=" + this.id + ", accountId=" + this.account.getId() + ", accountName=" + this.accountName + ", accountOrg=" + this.accountOrg + ", accountDep=" + this.accountDep + ", accountSubdomain=" + this.accountSubdomain + ", adminUsername=" + this.adminUsername + ", userEmail=" + this.userEmail + ", creationDate=" + this.creationDate + ", expirationDate=" + this.expirationDate + ", redemptionCode=" + this.redemptionCode + "]";
    }
}

