/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.manifest.xml;

import java.util.ArrayList;
import java.util.List;
import org.duracloud.ChunkType;
import org.duracloud.ChunksManifestDocument;
import org.duracloud.ChunksManifestType;
import org.duracloud.ChunksType;
import org.duracloud.HeaderType;
import org.duracloud.SourceContentType;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.manifest.ChunksManifestBean;
import org.duracloud.common.error.DuraCloudRuntimeException;

public class ManifestElementReader {
    private ManifestElementReader() {
    }

    public static ChunksManifest createManifestFrom(ChunksManifestDocument doc) {
        ChunksManifestType manifestType = doc.getChunksManifest();
        HeaderType headerType = manifestType.getHeader();
        ChunksManifestBean.ManifestHeader header = ManifestElementReader.createHeaderFromElement(headerType);
        ChunksType chunksType = manifestType.getChunks();
        List<ChunksManifestBean.ManifestEntry> entries = ManifestElementReader.createEntriesFromElement(chunksType);
        ChunksManifestBean manifestBean = new ChunksManifestBean();
        manifestBean.setHeader(header);
        manifestBean.setEntries(entries);
        return new ChunksManifest(manifestBean);
    }

    private static ChunksManifestBean.ManifestHeader createHeaderFromElement(HeaderType headerType) {
        ManifestElementReader.checkSchemaVersion(headerType.getSchemaVersion());
        SourceContentType sourceContentType = headerType.getSourceContent();
        String contentId = sourceContentType.getContentId();
        String mime = sourceContentType.getMimetype();
        String md5 = sourceContentType.getMd5();
        long size = sourceContentType.getByteSize();
        ChunksManifestBean.ManifestHeader header = new ChunksManifestBean.ManifestHeader(contentId, mime, size);
        header.setSourceMD5(md5);
        return header;
    }

    private static void checkSchemaVersion(String schemaVersion) {
        if (!schemaVersion.equals("0.2")) {
            throw new DuraCloudRuntimeException("Unsupported schema version: " + schemaVersion);
        }
    }

    private static List<ChunksManifestBean.ManifestEntry> createEntriesFromElement(ChunksType chunksType) {
        ArrayList<ChunksManifestBean.ManifestEntry> entries = new ArrayList<ChunksManifestBean.ManifestEntry>();
        ChunkType[] chunkTypes = chunksType.getChunkArray();
        if (null != chunkTypes && chunkTypes.length > 0) {
            for (ChunkType chunkType : chunkTypes) {
                String chunkId = chunkType.getChunkId();
                String md5 = chunkType.getMd5();
                int index = chunkType.getIndex();
                long size = chunkType.getByteSize();
                ChunksManifestBean.ManifestEntry entry = new ChunksManifestBean.ManifestEntry(chunkId, md5, index, size);
                entries.add(entry);
            }
        }
        return entries;
    }
}

