/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.writer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.duracloud.chunk.ChunkableContent;
import org.duracloud.chunk.error.NotFoundException;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.stream.ChunkInputStream;
import org.duracloud.chunk.stream.KnownLengthInputStream;
import org.duracloud.chunk.writer.AddContentResult;
import org.duracloud.chunk.writer.ContentWriter;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemContentWriter
implements ContentWriter {
    private final Logger log = LoggerFactory.getLogger(FilesystemContentWriter.class);
    private static final long TWO_GB = 2000000000L;
    private List<AddContentResult> results = new ArrayList<AddContentResult>();

    @Override
    public List<AddContentResult> getResults() {
        return this.results;
    }

    @Override
    public void ignore(String spaceId, String contentId, long contentSize) {
        AddContentResult result = new AddContentResult(spaceId, contentId, contentSize);
        result.setState(AddContentResult.State.IGNORED);
        this.results.add(result);
    }

    @Override
    public ChunksManifest write(String spaceId, ChunkableContent chunkable) throws NotFoundException {
        return this.write(spaceId, chunkable, null);
    }

    @Override
    public ChunksManifest write(String spaceId, ChunkableContent chunkable, Map<String, String> contentProperties) throws NotFoundException {
        for (ChunkInputStream chunk : chunkable) {
            this.writeSingle(spaceId, null, chunk, null);
        }
        ChunksManifest manifest = chunkable.finalizeManifest();
        KnownLengthInputStream manifestStream = manifest.getBody();
        AddContentResult result = this.writeContent(spaceId, manifest.getManifestId(), manifestStream, manifestStream.getLength(), contentProperties);
        result.setMd5("md5-not-collected-for-manifest");
        return manifest;
    }

    @Override
    public String writeSingle(String spaceId, String chunkChecksum, ChunkInputStream chunk, Map<String, String> properties) throws NotFoundException {
        AddContentResult result = this.writeContent(spaceId, chunk.getChunkId(), chunk, chunk.getChunkSize(), properties);
        String finalChecksum = chunk.getMD5();
        if (chunkChecksum != null && chunk.md5Preserved() && !chunkChecksum.equals(finalChecksum)) {
            result.setState(AddContentResult.State.ERROR);
        }
        result.setMd5(finalChecksum);
        return finalChecksum;
    }

    @Override
    public String writeSingle(String spaceId, String chunkChecksum, ChunkInputStream chunk) throws NotFoundException {
        return this.writeSingle(spaceId, chunkChecksum, chunk, null);
    }

    private AddContentResult writeContent(String spaceId, String contentId, InputStream inputStream, long contentSize, Map<String, String> contentProperties) {
        File spaceDir = this.getSpaceDir(spaceId);
        OutputStream outStream = this.getOutputStream(spaceDir, contentId);
        AddContentResult result = new AddContentResult(spaceId, contentId, contentSize);
        result.setState(AddContentResult.State.SUCCESS);
        try {
            if (contentSize > 2000000000L) {
                this.copyLarge(inputStream, outStream);
            } else {
                this.copy(inputStream, outStream);
            }
        }
        catch (Exception e) {
            result.setState(AddContentResult.State.ERROR);
        }
        this.flushAndClose(outStream);
        this.results.add(result);
        return result;
    }

    private void copyLarge(InputStream chunk, OutputStream outStream) {
        try {
            IOUtils.copyLarge(chunk, outStream);
        }
        catch (IOException e) {
            String msg = "Error in copy: " + chunk.toString() + ": ";
            this.log.error(msg, e);
            throw new DuraCloudRuntimeException(msg + e.getMessage(), e);
        }
    }

    private void copy(InputStream chunk, OutputStream outStream) {
        try {
            IOUtils.copy(chunk, outStream);
        }
        catch (IOException e) {
            String msg = "Error in copy: " + chunk.toString() + ": ";
            this.log.error(msg, e);
            throw new DuraCloudRuntimeException(msg + e.getMessage(), e);
        }
    }

    private OutputStream getOutputStream(File spaceDir, String contentId) {
        File outFile = this.getContentFile(spaceDir, contentId);
        return this.getOutputStream(outFile);
    }

    private OutputStream getOutputStream(File outFile) {
        int BUFFER_SIZE = 8192;
        try {
            return new BufferedOutputStream(new FileOutputStream(outFile), 8192);
        }
        catch (FileNotFoundException e) {
            throw new DuraCloudRuntimeException(e.getMessage(), e);
        }
    }

    private void flushAndClose(OutputStream outStream) {
        try {
            outStream.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly(outStream);
        }
    }

    private File getContentFile(File spaceDir, String contentId) {
        File contentFile = new File(spaceDir, contentId);
        File parent = contentFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        return contentFile;
    }

    private File getSpaceDir(String spaceId) {
        File spaceDir = new File(spaceId);
        if (!spaceDir.exists()) {
            spaceDir.mkdirs();
        }
        return spaceDir;
    }
}

