/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncoptimize.test;

import java.io.File;
import java.io.IOException;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.common.model.Credential;
import org.duracloud.error.ContentStoreException;
import org.duracloud.syncoptimize.config.SyncOptimizeConfig;
import org.duracloud.syncoptimize.status.SyncTestEvent;
import org.duracloud.syncoptimize.status.SyncTestStatus;
import org.duracloud.syncoptimize.test.SyncTester;

public class SyncTestManager {
    private SyncOptimizeConfig syncOptConfig;
    private File dataDir;
    private File workDir;
    private ContentStore contentStore;
    private SyncTestStatus syncStatus;
    private String prefix;
    private int transferedMB;
    private int minThreadCount = 2;
    private int initialMaxThreadCount = 30;

    public SyncTestManager(SyncOptimizeConfig syncOptConfig, File dataDir, File workDir, SyncTestStatus syncStatus, String prefix) throws IOException {
        this.syncOptConfig = syncOptConfig;
        this.dataDir = dataDir;
        this.workDir = workDir;
        this.syncStatus = syncStatus;
        this.prefix = prefix;
        this.contentStore = this.getContentStore();
        this.transferedMB = syncOptConfig.getNumFiles() * syncOptConfig.getSizeFiles();
    }

    public int runTest() {
        SyncTester syncTester = this.getSyncTester();
        int lowThreads = this.minThreadCount;
        int highThreads = this.initialMaxThreadCount;
        int optimalThreads = this.optimizeThreadCount(syncTester, lowThreads, highThreads);
        while (optimalThreads >= highThreads - 2) {
            optimalThreads = this.optimizeThreadCount(syncTester, optimalThreads, highThreads *= 2);
        }
        return optimalThreads;
    }

    private int optimizeThreadCount(SyncTester syncTester, int lowThreads, int highThreads) {
        SyncTestEvent lowEvent = this.runSyncTest(syncTester, lowThreads);
        SyncTestEvent highEvent = this.runSyncTest(syncTester, highThreads);
        return this.optimize(syncTester, lowThreads, lowEvent, highThreads, highEvent);
    }

    private int optimize(SyncTester syncTester, int lowThreads, SyncTestEvent lowEvent, int highThreads, SyncTestEvent highEvent) {
        if (highThreads - lowThreads <= 2) {
            if (lowEvent.getElapsed() < highEvent.getElapsed()) {
                return lowThreads;
            }
            return highThreads;
        }
        int midThreads = (lowThreads + highThreads) / 2;
        SyncTestEvent midEvent = this.runSyncTest(syncTester, midThreads);
        if (lowEvent.getElapsed() <= highEvent.getElapsed()) {
            highThreads = midThreads;
            highEvent = midEvent;
        } else {
            lowThreads = midThreads;
            lowEvent = midEvent;
        }
        return this.optimize(syncTester, lowThreads, lowEvent, highThreads, highEvent);
    }

    private SyncTestEvent runSyncTest(SyncTester syncTester, int threads) {
        long elapsed = syncTester.runSyncTest(threads);
        SyncTestEvent event = new SyncTestEvent(threads, elapsed, this.transferedMB);
        this.syncStatus.addEvent(event);
        return event;
    }

    protected SyncTester getSyncTester() {
        return new SyncTester(this.syncOptConfig, this.dataDir, this.workDir, this.contentStore, this.prefix);
    }

    protected ContentStore getContentStore() {
        ContentStoreManagerImpl storeManager = new ContentStoreManagerImpl(this.syncOptConfig.getHost(), String.valueOf(this.syncOptConfig.getPort()), this.syncOptConfig.getContext());
        Credential credential = new Credential(this.syncOptConfig.getUsername(), this.syncOptConfig.getPassword());
        storeManager.login(credential);
        try {
            return storeManager.getPrimaryContentStore();
        }
        catch (ContentStoreException e) {
            throw new RuntimeException("Unable to create ContentStore due to" + e.getMessage());
        }
    }
}

