/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.service;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.duracloud.sync.config.SyncToolConfig;

public class SyncToolConfigSerializer {
    private SyncToolConfigSerializer() {
    }

    public static SyncToolConfig deserialize(String syncToolConfigXmlPath) throws IOException {
        File f = new File(syncToolConfigXmlPath);
        FileInputStream fis = new FileInputStream(f);
        XStream xstream = new XStream();
        SyncToolConfigSerializer.configure(xstream);
        SyncToolConfig c = (SyncToolConfig)xstream.fromXML(fis);
        ((InputStream)fis).close();
        return c;
    }

    private static void configure(XStream xstream) {
        xstream.alias("syncToolConfig", SyncToolConfig.class);
    }

    public static void serialize(SyncToolConfig syncToolConfig, String syncToolConfigXmlPath) throws IOException {
        XStream xstream = new XStream();
        SyncToolConfigSerializer.configure(xstream);
        File file = new File(syncToolConfigXmlPath);
        file.getParentFile().mkdirs();
        FileWriter w = new FileWriter(file);
        xstream.toXML((Object)syncToolConfig, w);
        ((Writer)w).close();
    }
}

