/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.setup;

import org.duracloud.syncui.controller.ConfigurationController;
import org.duracloud.syncui.domain.AdvancedForm;
import org.duracloud.syncui.domain.DirectoryConfigs;
import org.duracloud.syncui.domain.DuracloudCredentialsForm;
import org.duracloud.syncui.domain.ModeForm;
import org.duracloud.syncui.domain.SpaceForm;
import org.duracloud.syncui.service.SyncConfigurationManager;
import org.duracloud.syncui.util.UpdatePolicyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SaveSetupAction {
    private static Logger log = LoggerFactory.getLogger(SaveSetupAction.class);
    private SyncConfigurationManager syncConfigurationManager;

    @Autowired
    public SaveSetupAction(@Qualifier(value="syncConfigurationManager") SyncConfigurationManager syncConfigurationManager) {
        this.syncConfigurationManager = syncConfigurationManager;
    }

    public String execute(DuracloudCredentialsForm credentials, SpaceForm spaceForm, DirectoryConfigs configs, AdvancedForm advancedForm, ModeForm modeForm) {
        this.syncConfigurationManager.persistDuracloudConfiguration(credentials.getUsername(), credentials.getPassword(), credentials.getHost(), credentials.getPort(), spaceForm.getSpaceId());
        this.syncConfigurationManager.persistDirectoryConfigs(configs);
        this.syncConfigurationManager.setSyncDeletes(advancedForm.isSyncDeletes());
        String up = advancedForm.getUpdatePolicy();
        log.debug("setting update policy to  {}", (Object)up);
        UpdatePolicyHelper.set(this.syncConfigurationManager, ConfigurationController.UpdatePolicy.valueOf(up));
        this.syncConfigurationManager.setJumpStart(advancedForm.isJumpStart());
        this.syncConfigurationManager.setMode(modeForm.getMode());
        log.info("successfully saved setup.");
        return "success";
    }
}

